/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb.man.text;

import io.solit.deb.man.RoffWriter;
import io.solit.deb.man.text.Literal;
import io.solit.deb.man.text.TextPart;
import io.solit.deb.man.text.TextRun;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Hyperlink
implements TextPart {
    private final List<Literal> text = new ArrayList<Literal>();
    private final String destination;

    public Hyperlink(String destination) {
        this.destination = destination;
    }

    public Hyperlink(String destination, String text) {
        this.destination = destination;
        this.text.add(new TextRun(text));
    }

    @Override
    public void write(RoffWriter writer) throws IOException {
        writer.startURL(this.destination);
        for (Literal t : this.text) {
            t.write(writer);
        }
        writer.completeURL();
    }

    public List<Literal> getText() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Hyperlink)) {
            return false;
        }
        Hyperlink hyperlink = (Hyperlink)o;
        return Objects.equals(this.text, hyperlink.text) && Objects.equals(this.destination, hyperlink.destination);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.destination);
    }

    public String toString() {
        return "Hyperlink{" + this.text + "(" + this.destination + ')' + '}';
    }
}

