/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb.man.parse;

import io.solit.deb.MarkdownUtils;
import io.solit.deb.man.ManPage;
import io.solit.deb.man.ManPart;
import io.solit.deb.man.Section;
import io.solit.deb.man.block.Example;
import io.solit.deb.man.block.Quote;
import io.solit.deb.man.block.Subheader;
import io.solit.deb.man.list.DefinitionList;
import io.solit.deb.man.list.ListElement;
import io.solit.deb.man.list.NumberedList;
import io.solit.deb.man.list.UnorderedList;
import io.solit.deb.man.parse.CurrentParagraph;
import io.solit.deb.man.parse.ManParseException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.Delimited;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;

class MarkdownParserWorker
extends AbstractVisitor {
    private static final Pattern HEADER_PATTERN = Pattern.compile("^\\s*(\\S+)\\((\\d+)\\)\\s*-+(.+)$");
    private final String source;
    private final String manual;
    private final String defaultName;
    private final int defaultSection;
    private final String defaultDescription;
    private final Consumer<String> warningHandler;
    private Node currentNode;
    private ManPage manPage;
    private Deque<Consumer<ManPart>> containers = new ArrayDeque<Consumer<ManPart>>();
    private CurrentParagraph currentParagraph;

    public MarkdownParserWorker(String source, String manual, String defName, int defSection, String defDesc, Consumer<String> warningHandler) {
        this.source = source;
        this.manual = manual;
        this.defaultName = defName;
        this.defaultSection = defSection;
        this.defaultDescription = defDesc;
        this.warningHandler = warningHandler;
    }

    public ManPage parse(Reader reader) throws IOException {
        Node root = Parser.builder().build().parseReader(reader);
        this.manPage = this.createManPage(root);
        while (this.currentNode != null) {
            this.readSection();
        }
        return this.manPage;
    }

    private ManPage createManPage(Node root) {
        Node c;
        ManPage result = null;
        boolean skippedNodes = false;
        for (c = root.getFirstChild(); c != null; c = c.getNext()) {
            if (c instanceof Heading) {
                Heading h = (Heading)c;
                if (h.getLevel() != 1) continue;
                String headerText = MarkdownUtils.extractText(c);
                Matcher header = HEADER_PATTERN.matcher(headerText);
                if (header.matches()) {
                    result = new ManPage(header.group(1).trim(), header.group(3).trim(), Integer.parseInt(header.group(2)));
                    if (!skippedNodes) break;
                    this.warningHandler.accept("Encountered content before manual header. This part will be ignored");
                    break;
                }
                this.warningHandler.accept("Manual header '" + headerText + "'does not match a required pattern, looking for another one");
                continue;
            }
            skippedNodes = true;
        }
        if (result == null) {
            if (this.defaultName == null) {
                throw new ManParseException("Unable to find manual header, check heading is present and is correct");
            }
            this.warningHandler.accept("Unable to find manual header, falling back to defaults");
            result = new ManPage(this.defaultName, this.defaultDescription, this.defaultSection);
            this.currentNode = root.getFirstChild();
        } else {
            this.currentNode = c.getNext();
        }
        result.setSource(this.source);
        result.setManual(this.manual);
        return result;
    }

    private void readSection() {
        Section section;
        if (!(this.currentNode instanceof Heading) || ((Heading)Heading.class.cast(this.currentNode)).getLevel() > 2) {
            section = new Section("\u00a0");
            this.warningHandler.accept("Encountered content without heading, using nameless section");
        } else {
            section = new Section(MarkdownUtils.extractText(this.currentNode));
            this.currentNode = this.currentNode.getNext();
        }
        this.manPage.getAdditionalSections().add(section);
        this.containers.push(section.getParts()::add);
        while (!(this.currentNode == null || this.currentNode instanceof Heading && ((Heading)Heading.class.cast(this.currentNode)).getLevel() <= 2)) {
            this.currentNode.accept((Visitor)this);
            this.currentNode = this.currentNode.getNext();
        }
        this.containers.pop();
    }

    private CurrentParagraph getParagraph() {
        if (this.currentParagraph == null) {
            throw new ManParseException("Text outside a paragraph");
        }
        return this.currentParagraph;
    }

    private CurrentParagraph visitParagraph(Paragraph paragraph, boolean expectTerm) {
        CurrentParagraph cp = this.currentParagraph = new CurrentParagraph(expectTerm);
        this.containers.push(c -> {
            throw new ManParseException("Unexpected node in a paragraph");
        });
        this.visitChildren((Node)paragraph);
        this.containers.pop();
        this.currentParagraph = null;
        return cp;
    }

    public void visit(BlockQuote blockQuote) {
        Quote quote = new Quote();
        this.containers.peek().accept(quote);
        this.containers.push(quote.getParts()::add);
        this.visitChildren((Node)blockQuote);
        this.containers.pop();
    }

    public void visit(BulletList bulletList) {
        new BulletListVisitor(bulletList.getBulletMarker() == '*' ? (char)'\u00b7' : '\u2014').visit(bulletList);
    }

    public void visit(Code code) {
        this.getParagraph().bold(true);
        this.getParagraph().monospace(true);
        this.getParagraph().appendText(code.getLiteral());
        this.getParagraph().monospace(false);
        this.getParagraph().bold(false);
    }

    private <T extends Node> void delimited(T node) {
        if (((Delimited)node).getOpeningDelimiter().charAt(0) == '*') {
            this.getParagraph().bold(true);
            this.visitChildren(node);
            this.getParagraph().bold(false);
        } else {
            this.getParagraph().italic(true);
            this.visitChildren(node);
            this.getParagraph().italic(false);
        }
    }

    public void visit(Emphasis emphasis) {
        this.delimited(emphasis);
    }

    public void visit(FencedCodeBlock fencedCodeBlock) {
        if (fencedCodeBlock.getLiteral() != null && !fencedCodeBlock.getLiteral().isEmpty()) {
            this.containers.peek().accept(new Example(fencedCodeBlock.getLiteral()));
        }
    }

    public void visit(HardLineBreak hardLineBreak) {
        this.getParagraph().breakLine();
    }

    public void visit(Heading heading) {
        String text = MarkdownUtils.extractText((Node)heading).trim();
        if (!text.isEmpty()) {
            this.containers.peek().accept(new Subheader(text));
        }
    }

    public void visit(HtmlInline htmlInline) {
        this.getParagraph().italic(true);
        String literal = htmlInline.getLiteral();
        int from = 0;
        int to = literal.length();
        if (literal.startsWith("<", from)) {
            ++from;
        }
        if (literal.endsWith(">")) {
            --to;
        }
        literal = literal.substring(from, to);
        this.getParagraph().appendText(literal);
        this.getParagraph().italic(false);
    }

    public void visit(HtmlBlock htmlBlock) {
        this.containers.peek().accept(new Example(htmlBlock.getLiteral()));
    }

    public void visit(Image image) {
        if (image.getDestination() != null) {
            this.getParagraph().beginLink(image.getDestination());
        }
        this.visitChildren((Node)image);
        if (image.getDestination() != null) {
            this.getParagraph().completeLink();
        }
    }

    public void visit(IndentedCodeBlock indentedCodeBlock) {
        if (indentedCodeBlock.getLiteral() != null && !indentedCodeBlock.getLiteral().isEmpty()) {
            this.containers.peek().accept(new Example(indentedCodeBlock.getLiteral()));
        }
    }

    public void visit(Link link) {
        if (link.getDestination() != null) {
            this.getParagraph().beginLink(link.getDestination());
        }
        this.visitChildren((Node)link);
        if (link.getDestination() != null) {
            this.getParagraph().completeLink();
        }
    }

    public void visit(OrderedList orderedList) {
        NumberedList part = new NumberedList();
        this.containers.peek().accept(part);
        for (Node n = orderedList.getFirstChild(); n != null; n = n.getNext()) {
            ListElement item = new ListElement();
            part.getItems().add(item);
            this.containers.push(item.getParts()::add);
            this.visitChildren(n);
            this.containers.pop();
        }
    }

    public void visit(Paragraph paragraph) {
        this.containers.peek().accept(this.visitParagraph(paragraph, false).returnParagraph());
    }

    public void visit(SoftLineBreak softLineBreak) {
        this.getParagraph().feedLine();
    }

    public void visit(StrongEmphasis strongEmphasis) {
        this.delimited(strongEmphasis);
    }

    public void visit(Text text) {
        this.getParagraph().appendText(text.getLiteral());
    }

    private class BulletListVisitor {
        private final char marker;
        private UnorderedList list;
        private DefinitionList definitions;

        private BulletListVisitor(char marker) {
            this.marker = marker;
        }

        private void addItem(ListElement item) {
            if (this.list == null) {
                this.list = new UnorderedList(this.marker);
                ((Consumer)MarkdownParserWorker.this.containers.peek()).accept(this.list);
                this.definitions = null;
            }
            this.list.getItems().add(item);
        }

        private void addDefinition(DefinitionList.DefinitionItem item) {
            if (this.definitions == null) {
                this.definitions = new DefinitionList();
                ((Consumer)MarkdownParserWorker.this.containers.peek()).accept(this.definitions);
                this.list = null;
            }
            this.definitions.getItems().add(item);
        }

        private ListElement fillItem(ListElement item, Node contentNode) {
            MarkdownParserWorker.this.containers.push(item.getParts()::add);
            for (Node n = contentNode; n != null; n = n.getNext()) {
                n.accept((Visitor)MarkdownParserWorker.this);
            }
            MarkdownParserWorker.this.containers.pop();
            return item;
        }

        public void visit(BulletList bulletList) {
            for (Node n = bulletList.getFirstChild(); n != null; n = n.getNext()) {
                if (n.getFirstChild() instanceof Paragraph) {
                    CurrentParagraph p = MarkdownParserWorker.this.visitParagraph((Paragraph)n.getFirstChild(), true);
                    DefinitionList.DefinitionItem di = p.returnDefinitionItem();
                    if (!(di == null || di.getDefinition().getParts().isEmpty() && n.getFirstChild().getNext() == null)) {
                        this.fillItem(di.getDefinition(), n.getFirstChild().getNext());
                        this.addDefinition(di);
                        continue;
                    }
                    if (di != null) {
                        this.addItem(this.fillItem(new ListElement(di.getTerm()), n.getFirstChild().getNext()));
                        continue;
                    }
                    this.addItem(this.fillItem(new ListElement(p.returnParagraph()), n.getFirstChild().getNext()));
                    continue;
                }
                this.addItem(this.fillItem(new ListElement(), n.getFirstChild()));
            }
        }
    }
}

