/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb.man.parse;

import io.solit.deb.man.block.ManParagraph;
import io.solit.deb.man.list.DefinitionList;
import io.solit.deb.man.list.ListElement;
import io.solit.deb.man.parse.ManParseException;
import io.solit.deb.man.text.FontSwitch;
import io.solit.deb.man.text.Hyperlink;
import io.solit.deb.man.text.LineBreak;
import io.solit.deb.man.text.Literal;
import io.solit.deb.man.text.TextRun;
import java.util.function.IntConsumer;

class CurrentParagraph {
    private ManParagraph term;
    private ManParagraph paragraph = new ManParagraph();
    private StringBuilder builder;
    private int italic;
    private int bold;
    private int monospace;
    private boolean pendingFont;
    private Hyperlink hyperlink;
    private boolean expectTerm;

    public CurrentParagraph(boolean expectTerm) {
        this.expectTerm = expectTerm;
    }

    private void addLiteral(Literal literal) {
        if (this.hyperlink != null) {
            this.hyperlink.getText().add(literal);
        } else {
            this.paragraph.getParts().add(literal);
        }
    }

    private void flush() {
        if (this.builder != null) {
            this.addLiteral(new TextRun(this.builder.toString()));
            this.builder = null;
        }
    }

    private void flushFont() {
        if (this.pendingFont) {
            this.addLiteral(new FontSwitch(this.bold > 0, this.italic > 0, this.monospace > 0));
            this.pendingFont = false;
        }
    }

    private boolean checkTerm() {
        if (this.expectTerm && this.builder != null && this.builder.length() > 0 && this.builder.charAt(this.builder.length() - 1) == ':') {
            this.expectTerm = false;
            this.flush();
            this.term = this.paragraph;
            this.paragraph = new ManParagraph();
            return true;
        }
        return false;
    }

    public void appendText(String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        if (this.builder != null) {
            this.builder.append(text);
        } else {
            this.flushFont();
            this.builder = new StringBuilder(text);
        }
    }

    public void monospace(boolean monospace) {
        this.switchFont(this.monospace, monospace, i -> {
            this.monospace = i;
        });
    }

    public void bold(boolean bold) {
        this.switchFont(this.bold, bold, i -> {
            this.bold = i;
        });
    }

    public void italic(boolean italic) {
        this.switchFont(this.italic, italic, i -> {
            this.italic = i;
        });
    }

    private void switchFont(int value, boolean direction, IntConsumer assignment) {
        int newVal = Math.max(0, value + (direction ? 1 : -1));
        if (newVal != value) {
            assignment.accept(newVal);
        }
        if (newVal > 0 ^ value > 0) {
            this.flush();
            this.pendingFont = true;
        }
    }

    public void beginLink(String destination) {
        if (this.hyperlink != null) {
            throw new ManParseException("Nesting hyperlinks is not allowed");
        }
        this.flush();
        this.hyperlink = new Hyperlink(destination);
        this.paragraph.getParts().add(this.hyperlink);
    }

    public void completeLink() {
        this.flush();
        this.flushFont();
        this.hyperlink = null;
    }

    public void breakLine() {
        this.flush();
        this.flushFont();
        this.expectTerm = false;
        this.addLiteral(new LineBreak());
    }

    public void feedLine() {
        if (!this.checkTerm()) {
            this.expectTerm = false;
            this.appendText(" ");
        }
    }

    public ManParagraph returnParagraph() {
        this.checkTerm();
        this.flush();
        this.flushFont();
        if (this.term != null) {
            throw new ManParseException("Paragraph is separated into term and definition");
        }
        return this.paragraph;
    }

    public DefinitionList.DefinitionItem returnDefinitionItem() {
        this.checkTerm();
        this.flush();
        this.flushFont();
        if (this.term != null) {
            return new DefinitionList.DefinitionItem(this.term, this.paragraph.getParts().isEmpty() ? new ListElement() : new ListElement(this.paragraph));
        }
        return null;
    }
}

