/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb.man.list;

import io.solit.deb.man.ManPart;
import io.solit.deb.man.RoffWriter;
import io.solit.deb.man.block.ManParagraph;
import io.solit.deb.man.list.ListElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefinitionList
implements ManPart {
    private List<DefinitionItem> items = new ArrayList<DefinitionItem>();

    public List<DefinitionItem> getItems() {
        return this.items;
    }

    public void addItem(ManParagraph term, ManPart definition) {
        this.getItems().add(new DefinitionItem(term, new ListElement(definition)));
    }

    @Override
    public void write(RoffWriter writer) throws IOException {
        for (DefinitionItem item : this.items) {
            writer.writeStructureLine();
            writer.startTaggedParagraph(4);
            item.getTerm().write(writer);
            writer.write("\n");
            item.getDefinition().write(writer);
        }
    }

    public static class DefinitionItem {
        final ManParagraph term;
        final ListElement definition;

        public DefinitionItem(ManParagraph term, ListElement definition) {
            this.term = Objects.requireNonNull(term);
            this.definition = Objects.requireNonNull(definition);
        }

        public ManParagraph getTerm() {
            return this.term;
        }

        public ListElement getDefinition() {
            return this.definition;
        }
    }
}

