/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb.man;

import io.solit.deb.man.ManPart;
import io.solit.deb.man.RoffWriter;
import io.solit.deb.man.block.ManParagraph;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Section {
    private final String name;
    private final List<ManPart> parts = new ArrayList<ManPart>();

    public Section(String name) {
        this.name = Objects.requireNonNull(name, "Name should not be null");
    }

    public List<ManPart> getParts() {
        return this.parts;
    }

    public void write(RoffWriter roffWriter) throws IOException {
        roffWriter.writeStructureLine();
        roffWriter.writeHeader(this.name.toUpperCase());
        for (ManPart part : this.parts) {
            if (part instanceof ManParagraph) {
                roffWriter.startParagraph();
            }
            part.write(roffWriter);
        }
    }

    public String getName() {
        return this.name;
    }
}

