/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb.man;

import java.io.IOException;
import java.io.Writer;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class RoffWriter
extends Writer {
    private final Writer writer;
    private boolean newLine = true;
    private char breakingRequestChar = (char)46;
    private char nonBreakingRequestChar = (char)39;
    private char escapeChar = (char)92;

    public RoffWriter(Writer destination) {
        super((Object)destination);
        this.writer = destination;
    }

    private void startRequest() throws IOException {
        this.newLine();
        this.writer.write(this.breakingRequestChar);
        this.newLine = false;
    }

    private void newLine() throws IOException {
        if (!this.newLine) {
            this.writer.write(10);
            this.newLine = true;
        }
    }

    private void writeMacroArgument(CharSequence sequence) throws IOException {
        this.writer.write(32);
        this.writer.write(34);
        int l = sequence.length();
        for (int i = 0; i < l; ++i) {
            char c = sequence.charAt(i);
            if (c == '\n') {
                this.writer.write("\\n");
                continue;
            }
            if (c == '\"') {
                this.writer.write("\\\"");
                continue;
            }
            if (this.writeSpecial(c)) continue;
            this.writer.write(c);
        }
        this.writer.write(34);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStructureLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeManHeader(String title, int manSection, LocalDate date, String source, String manual) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("TH");
            this.writeMacroArgument(title.toUpperCase());
            this.writeMacroArgument(Integer.toString(manSection));
            this.writeMacroArgument(date.format(DateTimeFormatter.ISO_DATE));
            this.writeMacroArgument(source);
            this.writeMacroArgument(manual);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCommentLine(String comment) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (comment.indexOf(10) >= 0) {
                throw new IllegalArgumentException("Comment line should not contain line breaks");
            }
            this.startRequest();
            this.writer.write("\\\" ");
            this.writer.write(comment);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeader(String header) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("SH");
            this.writeMacroArgument(header);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSubHeader(String subHeader) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("SS");
            this.writeMacroArgument(subHeader);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startParagraph() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("P");
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTaggedParagraph(int indentation) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("TP ");
            this.writer.write(Integer.toString(indentation));
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startIndentedParagraph(String hangingTag, int indentation) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("IP");
            this.writeMacroArgument(hangingTag == null ? "" : hangingTag);
            this.writer.write(" ");
            this.writer.write(Integer.toString(indentation));
            this.newLine();
        }
    }

    public void startIndentedParagraph(int indentation) throws IOException {
        this.startIndentedParagraph(null, indentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startURL(String url) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("UR");
            this.writeMacroArgument(url);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeURL(String trailer) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("UE");
            if (trailer != null) {
                this.writeMacroArgument(trailer);
            }
            this.newLine();
        }
    }

    public void completeURL() throws IOException {
        this.completeURL(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openBlock() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("RS");
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openBlock(int indentation) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("RS ");
            this.writer.write(Integer.toString(indentation));
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeBlock() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("RE");
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("br");
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableFilling() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("nf");
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableFilling() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("fi");
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableHyphenation() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.startRequest();
            this.writer.write("nh");
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchFont(boolean bold, boolean italic, boolean monospace) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char[] c = new char[3];
            int i = 0;
            if (monospace) {
                c[i++] = 67;
            }
            if (bold) {
                c[i++] = 66;
            }
            if (italic) {
                c[i++] = 73;
            }
            if (!bold && !italic) {
                c[i++] = 82;
            }
            this.writer.write("\\f");
            switch (i) {
                case 1: {
                    this.writer.write(c, 0, i);
                    break;
                }
                case 2: {
                    this.writer.write(40);
                    this.writer.write(c, 0, i);
                    break;
                }
                case 3: {
                    this.writer.write(91);
                    this.writer.write(c, 0, i);
                    this.writer.write(93);
                }
            }
            this.newLine = false;
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.append(new ArraySequence(Objects.requireNonNull(cbuf), off, len));
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.append(new ArraySequence(cbuf, 0, cbuf.length));
    }

    @Override
    public void write(String str) throws IOException {
        this.append(Objects.requireNonNull(str), 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.append(Objects.requireNonNull(str), off, off + len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        if (csq == null) {
            this.append("null", 0, 4);
        } else {
            this.append(csq, 0, csq.length());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (csq == null) {
                csq = "null";
            }
            if (start < 0 || end > csq.length() || start > end) {
                throw new IndexOutOfBoundsException(String.format("Illegal stat or end '%d-%d' of [%d, %d)", start, end, 0, csq.length()));
            }
            for (int i = start; i < end; ++i) {
                char c = csq.charAt(i);
                if (c == '\n' && !this.newLine) {
                    this.writer.write(c);
                    this.newLine = true;
                    continue;
                }
                if ((c == this.breakingRequestChar || c == this.nonBreakingRequestChar) && this.newLine) {
                    this.writer.write("\\&");
                    this.writer.write(c);
                } else if (!this.writeSpecial(c)) {
                    this.writer.write(c);
                }
                this.newLine = false;
            }
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private boolean writeSpecial(char c) throws IOException {
        switch (c) {
            case '$': {
                this.writer.write(this.escapeChar);
                this.writer.write("(Do");
                break;
            }
            case '\u20ac': {
                this.writer.write(this.escapeChar);
                this.writer.write("(Eu");
                break;
            }
            case '\u00a3': {
                this.writer.write(this.escapeChar);
                this.writer.write("(Po");
                break;
            }
            case '\'': {
                this.writer.write(this.escapeChar);
                this.writer.write("(aq");
                break;
            }
            case '\u00b7': {
                this.writer.write(this.escapeChar);
                this.writer.write("(bu");
                break;
            }
            case '\u00a9': {
                this.writer.write(this.escapeChar);
                this.writer.write("(co");
                break;
            }
            case '\u2019': {
                this.writer.write(this.escapeChar);
                this.writer.write("(cq");
                break;
            }
            case '\u00a2': {
                this.writer.write(this.escapeChar);
                this.writer.write("(ct");
                break;
            }
            case '\u2021': {
                this.writer.write(this.escapeChar);
                this.writer.write("(dd");
                break;
            }
            case '\u00b0': {
                this.writer.write(this.escapeChar);
                this.writer.write("(de");
                break;
            }
            case '\u2020': {
                this.writer.write(this.escapeChar);
                this.writer.write("(dg");
                break;
            }
            case '\"': {
                this.writer.write(this.escapeChar);
                this.writer.write("(dq");
                break;
            }
            case '\u2014': {
                this.writer.write(this.escapeChar);
                this.writer.write("(em");
                break;
            }
            case '\u2013': {
                this.writer.write(this.escapeChar);
                this.writer.write("(en");
                break;
            }
            case '\u2010': {
                this.writer.write(this.escapeChar);
                this.writer.write("(hy");
                break;
            }
            case '\u201c': {
                this.writer.write(this.escapeChar);
                this.writer.write("(lq");
                break;
            }
            case '\u2018': {
                this.writer.write(this.escapeChar);
                this.writer.write("(oq");
                break;
            }
            case '\u00ae': {
                this.writer.write(this.escapeChar);
                this.writer.write("(rg");
                break;
            }
            case '\u201d': {
                this.writer.write(this.escapeChar);
                this.writer.write("(rq");
                break;
            }
            case '\\': {
                this.writer.write(this.escapeChar);
                this.writer.write("(rs");
                break;
            }
            case '\u00a7': {
                this.writer.write(this.escapeChar);
                this.writer.write("(sc");
                break;
            }
            case '\u2122': {
                this.writer.write(this.escapeChar);
                this.writer.write("(tm");
                break;
            }
            case '_': {
                this.writer.write(this.escapeChar);
                this.writer.write("(ul");
                break;
            }
            case '\u2261': {
                this.writer.write(this.escapeChar);
                this.writer.write("(==");
                break;
            }
            case '\u2265': {
                this.writer.write(this.escapeChar);
                this.writer.write("(>=");
                break;
            }
            case '\u2264': {
                this.writer.write(this.escapeChar);
                this.writer.write("(<=");
                break;
            }
            case '\u2260': {
                this.writer.write(this.escapeChar);
                this.writer.write("(!=");
                break;
            }
            case '\u2192': {
                this.writer.write(this.escapeChar);
                this.writer.write("(->");
                break;
            }
            case '\u2190': {
                this.writer.write(this.escapeChar);
                this.writer.write("(<-");
                break;
            }
            case '\u00b1': {
                this.writer.write(this.escapeChar);
                this.writer.write("(+-");
                break;
            }
            case '-': {
                this.writer.write(this.escapeChar);
                this.writer.write("-");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private class ArraySequence
    implements CharSequence {
        private final char[] chars;
        private final int len;
        private final int offset;

        private ArraySequence(char[] chars, int len, int offset) {
            this.chars = chars;
            this.len = len;
            this.offset = offset;
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public char charAt(int index) {
            if (index < 0 || index >= this.len) {
                throw new IndexOutOfBoundsException(index + " is not in [0," + this.len + ")");
            }
            return this.chars[index + this.offset];
        }

        @Override
        public String toString() {
            return new String(this.chars, this.offset, this.len);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start < 0) {
                throw new IndexOutOfBoundsException(start + " is not in [0," + this.len + ")");
            }
            if (end > this.len) {
                throw new IndexOutOfBoundsException(end + " is not in [0," + this.len + ")");
            }
            int subLen = end - start;
            if (subLen < 0) {
                throw new IndexOutOfBoundsException("End is before start");
            }
            return new ArraySequence(this.chars, this.offset + start, subLen);
        }
    }
}

