/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb.man;

import io.solit.deb.man.RoffWriter;
import io.solit.deb.man.Section;
import java.io.IOException;
import java.io.Writer;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ManPage {
    private static final String NAME_SECTION = "NAME";
    private final String title;
    private final int manSection;
    private String source = "Linux";
    private String manual = "Manual";
    private LocalDate date;
    private String name;
    private String shortDescription;
    private final List<Section> additionalSections = new ArrayList<Section>();

    public ManPage(String title, String desc, int manSection) {
        this.title = Objects.requireNonNull(title, "Manual title should not be null");
        this.name = title;
        this.shortDescription = Objects.requireNonNull(desc, "Description must not be null");
        this.manSection = manSection;
        this.date = LocalDate.now();
    }

    public String getTitle() {
        return this.title;
    }

    public int getManSection() {
        return this.manSection;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = Objects.requireNonNull(date, "Date should not be null");
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = Objects.requireNonNull(source, "Source must not be null");
    }

    public String getManual() {
        return this.manual;
    }

    public void setManual(String manual) {
        this.manual = Objects.requireNonNull(manual, "Manual must not be null");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNull(name, "Name must not be null");
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public List<Section> getAdditionalSections() {
        return this.additionalSections;
    }

    public void write(Writer writer) throws IOException {
        RoffWriter roffWriter = new RoffWriter(writer);
        roffWriter.writeCommentLine("Generated with deb-maven-plugin");
        roffWriter.writeStructureLine();
        roffWriter.writeManHeader(this.title, this.manSection, this.date, this.source, this.manual);
        roffWriter.disableHyphenation();
        roffWriter.writeStructureLine();
        roffWriter.writeHeader(NAME_SECTION);
        roffWriter.write(this.name);
        roffWriter.write(" - ");
        roffWriter.write(this.shortDescription);
        for (Section as : this.additionalSections) {
            as.write(roffWriter);
        }
    }
}

