/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb.copyright;

import io.solit.deb.ControlFileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class CopyrightFiles {
    private static final String FILES_HEADER = "Files";
    private static final String COPYRIGHT_HEADER = "Copyright";
    private static final String LICENCE_HEADER = "Licence";
    private static final String COMMENT_HEADER = "Comment";
    private final Set<String> files = new LinkedHashSet<String>();
    private final String copyright;
    private final String licence;
    private String licenceContent;
    private String comment;

    CopyrightFiles(Set<String> files, String copyright, String licence) {
        if (files.isEmpty()) {
            throw new IllegalArgumentException("No files specified");
        }
        files.forEach(this::addFile);
        if (copyright == null) {
            throw new NullPointerException("Copyright is missing");
        }
        if ((copyright = copyright.trim()).isEmpty()) {
            throw new IllegalArgumentException("Copyright should not be empty");
        }
        if (licence == null) {
            throw new NullPointerException("Licence is missing");
        }
        if ((licence = licence.trim()).isEmpty()) {
            throw new IllegalArgumentException("Licence is empty");
        }
        if (licence.contains("\n")) {
            throw new IllegalArgumentException("Licence name should not contain line separators");
        }
        this.copyright = copyright;
        this.licence = licence;
    }

    public Set<String> getFiles() {
        return Collections.unmodifiableSet(this.files);
    }

    public void addFile(String filePattern) {
        if (filePattern == null) {
            throw new IllegalArgumentException("File can not be null");
        }
        if ((filePattern = filePattern.trim()).isEmpty()) {
            throw new IllegalArgumentException("File can not be empty");
        }
        boolean escaped = false;
        for (int i = 0; i < filePattern.length(); ++i) {
            if (filePattern.charAt(i) == '\\') {
                escaped = !escaped;
                continue;
            }
            if (escaped) {
                switch (filePattern.charAt(i)) {
                    case '*': 
                    case '?': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal escape sequence at '" + filePattern + "'");
                    }
                }
                escaped = false;
                continue;
            }
            if (!Character.isWhitespace(filePattern.charAt(i))) continue;
            throw new IllegalArgumentException("Forbidden whitespace chars at '" + filePattern + "'");
        }
        if (escaped) {
            throw new IllegalArgumentException("Illegal escape sequence at '" + filePattern + "'");
        }
        this.files.add(filePattern);
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getLicence() {
        return this.licence;
    }

    public String getLicenceContent() {
        return this.licenceContent;
    }

    public void setLicenceContent(String licenceContent) {
        this.licenceContent = licenceContent;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void writeFiles(ControlFileWriter controlWriter) throws IOException {
        controlWriter.writeMultiLineList(FILES_HEADER, this.files);
        controlWriter.writeFormattedField(COPYRIGHT_HEADER, null, this.copyright);
        controlWriter.writeFormattedField(LICENCE_HEADER, this.licence, this.licenceContent);
        if (this.comment != null) {
            controlWriter.writeFormattedField(COMMENT_HEADER, null, this.comment);
        }
    }
}

