/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb.changes;

import io.solit.deb.changes.Changes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.node.Visitor;

public class MarkdownChanges
implements Changes {
    private final List<Node> content = new ArrayList<Node>();

    public MarkdownChanges(List<Node> content) {
        if (Objects.requireNonNull(content, "Content should not be null").isEmpty()) {
            throw new IllegalArgumentException("Content should not be empty");
        }
        this.content.addAll(content);
    }

    public MarkdownChanges(Node ... content) {
        this(Arrays.asList(content));
    }

    @Override
    public Iterator<String> iterator() {
        return new ToStringVisitor(this.content);
    }

    public List<Node> getContent() {
        return this.content;
    }

    private static class Prefix {
        private final String prefix;
        private final String continuationPrefix;

        public Prefix(String prefix, String continuationPrefix) {
            this.prefix = prefix;
            this.continuationPrefix = continuationPrefix;
        }

        public Prefix(String prefix) {
            this.prefix = prefix;
            this.continuationPrefix = prefix;
        }

        public Prefix extend(CharSequence extension) {
            return new Prefix(this.prefix + extension);
        }

        public Prefix extend(CharSequence extension, CharSequence continuation) {
            return new Prefix(this.prefix + extension, this.prefix + continuation);
        }

        public Prefix continuation() {
            return new Prefix(this.continuationPrefix);
        }

        public StringBuilder firstLine() {
            return new StringBuilder(this.prefix);
        }

        public StringBuilder continuationLine() {
            return new StringBuilder(this.continuationPrefix);
        }
    }

    private static class MarkerNode
    extends CustomNode {
        private final Runnable runnable;

        private MarkerNode(Runnable runnable) {
            this.runnable = runnable;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }
    }

    private static class ToStringVisitor
    implements Visitor,
    Iterator<String> {
        private Queue<String> buffer = new ArrayDeque<String>();
        private Deque<Node> front = new ArrayDeque<Node>();
        private Deque<Prefix> prefixFront = new ArrayDeque<Prefix>();
        private StringBuilder lineBuilder;

        public ToStringVisitor(List<Node> nodes) {
            ListIterator<Node> i = nodes.listIterator(nodes.size());
            while (i.hasPrevious()) {
                this.front.push(i.previous());
                this.prefixFront.push(new Prefix(""));
            }
        }

        private void scheduleInline(Node node, MarkerNode ... markers) {
            for (int i = markers.length; i > 0; --i) {
                this.front.push((Node)markers[i - 1]);
            }
            for (Node n = node.getLastChild(); n != null; n = n.getPrevious()) {
                this.front.push(n);
            }
        }

        public void visit(BlockQuote blockQuote) {
            Prefix p = this.prefixFront.pop().extend("> ");
            if (this.front.size() != this.prefixFront.size()) {
                throw new AssertionError((Object)"Prefix size de-sync");
            }
            for (Node n = blockQuote.getLastChild(); n != null; n = n.getPrevious()) {
                this.front.push(n);
                this.prefixFront.push(p);
            }
        }

        public void visit(BulletList bulletList) {
            Prefix p = this.prefixFront.pop().extend(bulletList.getBulletMarker() + "   ", "    ");
            for (Node n = bulletList.getLastChild(); n != null; n = n.getPrevious()) {
                this.front.push(n);
                this.prefixFront.push(p);
            }
        }

        public void visit(Code code) {
            this.getLineBuilder().append('`').append(code.getLiteral()).append('`');
        }

        public void visit(Document document) {
            Prefix p = this.prefixFront.pop();
            if (this.front.size() != this.prefixFront.size()) {
                throw new AssertionError((Object)"Prefix size de-sync");
            }
            for (Node n = document.getLastChild(); n != null; n = n.getPrevious()) {
                this.front.push(n);
                this.prefixFront.push(p);
            }
        }

        public void visit(Emphasis emphasis) {
            this.getLineBuilder().append(emphasis.getOpeningDelimiter());
            this.scheduleInline((Node)emphasis, this.getClosingNode(emphasis.getClosingDelimiter()));
        }

        public void writeCodeBlock(String literal, CharSequence header, CharSequence footer, CharSequence infix) {
            int index;
            Prefix prefix = this.prefixFront.pop();
            if (header != null) {
                this.buffer.add(prefix.firstLine().append(header).toString());
                index = 1;
            } else {
                index = 0;
            }
            for (String s : literal.split("\r\n|[\r\n]")) {
                if (index++ == 0) {
                    this.buffer.add(prefix.firstLine().append(infix).append(s).toString());
                    continue;
                }
                this.buffer.add(prefix.continuationLine().append(infix).append(s).toString());
            }
            if (footer != null) {
                if (index == 0) {
                    this.buffer.add(prefix.firstLine().append(footer).toString());
                } else {
                    this.buffer.add(prefix.continuationLine().append(footer).toString());
                }
            }
        }

        public void visit(FencedCodeBlock fencedCodeBlock) {
            StringBuilder header = new StringBuilder(fencedCodeBlock.getFenceLength() + fencedCodeBlock.getInfo().length());
            StringBuilder footer = new StringBuilder(fencedCodeBlock.getFenceLength());
            for (int i = 0; i < fencedCodeBlock.getFenceLength(); ++i) {
                header.append(fencedCodeBlock.getFenceChar());
                footer.append(fencedCodeBlock.getFenceChar());
            }
            this.writeCodeBlock(fencedCodeBlock.getLiteral(), header.append(fencedCodeBlock.getInfo()), footer, "");
        }

        public void visit(HardLineBreak hardLineBreak) {
            this.getLineBuilder().append("  ");
            this.flush(this.prefixFront.peek().continuationLine());
        }

        public void visit(Heading heading) {
            this.prefixFront.push(this.prefixFront.pop().extend(String.join((CharSequence)"", Collections.nCopies(heading.getLevel(), "#")) + " "));
            this.scheduleInline((Node)heading, this.getFlushNode());
        }

        public void visit(ThematicBreak thematicBreak) {
            this.flush(null);
            if (thematicBreak.getPrevious() instanceof Paragraph) {
                this.buffer.add("");
            }
            this.buffer.add("---");
        }

        public void visit(HtmlInline htmlInline) {
            this.getLineBuilder().append(htmlInline.getLiteral());
        }

        public void visit(HtmlBlock htmlBlock) {
            this.writeCodeBlock(htmlBlock.getLiteral(), null, null, "");
        }

        private void visitLink(Node node, String destination, String title, String open) {
            if (destination != null) {
                this.getLineBuilder().append(open).append("[");
                this.scheduleInline(node, this.getClosingNode("](" + destination + (title != null ? " \"" + title + "\"" : "") + ")"));
            } else {
                this.scheduleInline(node, new MarkerNode[0]);
            }
        }

        public void visit(Image image) {
            this.visitLink((Node)image, image.getDestination(), image.getTitle(), "!");
        }

        public void visit(IndentedCodeBlock indentedCodeBlock) {
            this.writeCodeBlock(indentedCodeBlock.getLiteral(), null, null, "    ");
        }

        public void visit(Link link) {
            this.visitLink((Node)link, link.getDestination(), link.getTitle(), "");
        }

        public void visit(ListItem listItem) {
            Prefix p = this.prefixFront.pop();
            Prefix c = p.continuation();
            if (this.front.size() != this.prefixFront.size()) {
                throw new AssertionError((Object)"Prefix size de-sync");
            }
            for (Node n = listItem.getLastChild(); n != null; n = n.getPrevious()) {
                this.front.push(n);
                this.prefixFront.push(n.getPrevious() == null ? p : c);
            }
        }

        public void visit(OrderedList orderedList) {
            Node n;
            ArrayDeque<Prefix> prefixes = new ArrayDeque<Prefix>();
            Prefix cur = this.prefixFront.pop();
            if (this.front.size() != this.prefixFront.size()) {
                throw new AssertionError((Object)"Prefix size de-sync");
            }
            int index = 0;
            for (n = orderedList.getFirstChild(); n != null; n = n.getNext()) {
                int i;
                StringBuilder fl = new StringBuilder();
                StringBuilder cl = new StringBuilder();
                fl.append(orderedList.getStartNumber() + index++).append(".");
                for (i = fl.length(); i > 0; --i) {
                    cl.append(' ');
                }
                for (i = 4 - fl.length(); i > 0; --i) {
                    fl.append(' ');
                    cl.append(' ');
                }
                prefixes.push(cur.extend(fl, cl));
            }
            for (n = orderedList.getLastChild(); n != null; n = n.getPrevious()) {
                this.front.push(n);
                this.prefixFront.push((Prefix)prefixes.pop());
            }
        }

        public void visit(Paragraph paragraph) {
            if (paragraph.getPrevious() instanceof Paragraph || paragraph.getPrevious() instanceof ListBlock) {
                this.buffer.add(this.prefixFront.peek().firstLine().toString().trim());
            }
            this.scheduleInline((Node)paragraph, this.getFlushNode());
        }

        public void visit(SoftLineBreak softLineBreak) {
            this.flush(this.prefixFront.peek().continuationLine());
        }

        public void visit(StrongEmphasis strongEmphasis) {
            this.getLineBuilder().append(strongEmphasis.getOpeningDelimiter());
            String closing = strongEmphasis.getClosingDelimiter();
            this.scheduleInline((Node)strongEmphasis, this.getClosingNode(closing));
        }

        public void visit(Text text) {
            this.getLineBuilder().append(text.getLiteral());
        }

        public void visit(CustomBlock customBlock) {
            throw new UnsupportedOperationException();
        }

        public void visit(CustomNode customNode) {
            if (!(customNode instanceof MarkerNode)) {
                throw new UnsupportedOperationException();
            }
            ((MarkerNode)((Object)MarkerNode.class.cast(customNode))).getRunnable().run();
        }

        @Override
        public boolean hasNext() {
            while (this.buffer.isEmpty() && !this.front.isEmpty()) {
                this.front.pop().accept((Visitor)this);
            }
            return !this.buffer.isEmpty();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.buffer.poll();
        }

        private MarkerNode getClosingNode(String closing) {
            return new MarkerNode(() -> this.getLineBuilder().append(closing));
        }

        private MarkerNode getFlushNode() {
            return new MarkerNode(() -> {
                this.flush(null);
                this.prefixFront.pop();
            });
        }

        private void flush(StringBuilder replacement) {
            if (this.lineBuilder != null) {
                this.buffer.add(this.lineBuilder.toString());
                this.lineBuilder = replacement;
            }
        }

        private StringBuilder getLineBuilder() {
            if (this.lineBuilder == null) {
                this.lineBuilder = this.prefixFront.peek().firstLine();
            }
            return this.lineBuilder;
        }
    }
}

