/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb.changes;

import io.solit.deb.MarkdownUtils;
import io.solit.deb.Version;
import io.solit.deb.changes.ChangeSet;
import io.solit.deb.changes.Changelog;
import io.solit.deb.changes.Changes;
import io.solit.deb.changes.MarkdownChanges;
import io.solit.deb.changes.StringChanges;
import java.io.IOException;
import java.io.Reader;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.node.BulletList;
import org.commonmark.node.Heading;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.commonmark.parser.Parser;

public class KeepChangelogParser {
    private static final Pattern CHANGE_HEADING = Pattern.compile("\\s*\\[([\\w.:+~-]+)]\\s*-+\\s*(\\d{4}-\\d{2}-\\d{2})(?:T(\\d{2}:\\d{2}:\\d{2}))?([A-Z]*(?:[+-][\\d:]+)?)?\\s*(\\[YANKED])?");
    private static final Pattern COLON_PAIR = Pattern.compile("^([^:]+):(.+)$");
    private static final String RELEASE_HEADER = "release";
    private static final String SECURITY_HEADER = "security";
    private static final Pattern URGENCY_PARSER = Pattern.compile("(low|medium|high|emergency|critical)(?:\\s*\\((.*)\\))?", 2);
    private static final Pattern MAINTAINER_PARSER = Pattern.compile("(.*)[\\s<]+([a-zA-Z0-9_.+-]+@[a-zA-Z0-9.-]+)>?");
    public static final String UNRELEASED = "[Unreleased]";
    private final String packageName;
    private final String defaultMaintainer;
    private final String defaultMaintainerEmail;
    private String defaultDistribution;
    private Version unreleasedVersion;

    public KeepChangelogParser(String packageName, String defaultMaintainer, String defaultMaintainerEmail) {
        this.packageName = Objects.requireNonNull(packageName, "Package name should be specified");
        this.defaultMaintainer = Objects.requireNonNull(defaultMaintainer, "Default maintainer should not be null");
        this.defaultMaintainerEmail = Objects.requireNonNull(defaultMaintainerEmail, "Defualt maintainer email should not be null");
    }

    public void setDefaultDistribution(String defaultDistribution) {
        this.defaultDistribution = defaultDistribution;
    }

    public void setUnreleasedVersion(Version unreleasedVersion) {
        this.unreleasedVersion = unreleasedVersion;
    }

    public Changelog parse(Reader changelogReader) throws IOException {
        ChangeSet set;
        Node document = Parser.builder().build().parseReader(changelogReader);
        ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        ChangeAccumulator accumulator = null;
        Node n = document.getFirstChild();
        while (n != null) {
            Heading h;
            if (n instanceof Heading && (h = (Heading)n).getLevel() <= 2) {
                ChangeSet set2;
                if (accumulator != null && (set2 = accumulator.createSet()) != null) {
                    changeSets.add(set2);
                }
                accumulator = h.getLevel() == 2 ? this.parseChangeSet(h) : null;
                n = n.getNext();
                continue;
            }
            if (accumulator != null) {
                n = accumulator.accept(n);
                continue;
            }
            n = n.getNext();
        }
        if (accumulator != null && (set = accumulator.createSet()) != null) {
            changeSets.add(set);
        }
        return changeSets.isEmpty() ? null : new Changelog(changeSets);
    }

    private ChangeAccumulator parseChangeSet(Heading heading) {
        String headingText = MarkdownUtils.extractText((Node)heading);
        Matcher matcher = CHANGE_HEADING.matcher(headingText);
        if (matcher.matches()) {
            Version version = Version.parseVersion(matcher.group(1));
            ZonedDateTime dateTime = this.getZonedDateTime(matcher.group(2), matcher.group(3), matcher.group(4));
            return new ChangeAccumulator(version, dateTime, matcher.group(5) != null);
        }
        if (this.unreleasedVersion != null && UNRELEASED.equalsIgnoreCase(headingText)) {
            return new ChangeAccumulator(this.unreleasedVersion, ZonedDateTime.now(), false);
        }
        return null;
    }

    private ZonedDateTime getZonedDateTime(String date, String time, String zone) {
        return ZonedDateTime.of(LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE), time == null ? LocalTime.MIDNIGHT : LocalTime.parse(time, DateTimeFormatter.ISO_LOCAL_TIME), zone == null || zone.isEmpty() ? ZoneId.of("+0000") : ZoneId.of(zone));
    }

    private class ChangeAccumulator {
        private final Version version;
        private final ZonedDateTime date;
        private final boolean yanked;
        private String packageName;
        private String maintainer;
        private String maintainerEmail;
        private String distribution;
        private String urgencyComment;
        private ChangeSet.Urgency urgency;
        private List<Node> nodes;

        private ChangeAccumulator(Version version, ZonedDateTime date, boolean yanked) {
            this.packageName = KeepChangelogParser.this.packageName;
            this.maintainer = KeepChangelogParser.this.defaultMaintainer;
            this.maintainerEmail = KeepChangelogParser.this.defaultMaintainerEmail;
            this.distribution = KeepChangelogParser.this.defaultDistribution;
            this.urgencyComment = null;
            this.urgency = null;
            this.nodes = new ArrayList<Node>();
            this.version = Objects.requireNonNull(version, "Version should not be null");
            this.date = Objects.requireNonNull(date, "Date should not be null");
            this.yanked = yanked;
        }

        public ChangeSet createSet() {
            Changes changes;
            if (!this.nodes.isEmpty()) {
                changes = new MarkdownChanges(this.nodes);
            } else if (this.yanked) {
                changes = StringChanges.YANKED;
            } else {
                return null;
            }
            ChangeSet set = new ChangeSet(this.packageName, this.version, this.maintainer, this.maintainerEmail, changes);
            set.setDate(this.date);
            if (this.distribution != null) {
                set.setDistribution(this.distribution);
            }
            if (this.urgencyComment != null) {
                set.setUrgencyCommentary(this.urgencyComment);
            }
            if (this.urgency != null) {
                set.setUrgency(this.urgency);
            }
            return set;
        }

        public Node accept(Node node) {
            if (node instanceof Heading) {
                Heading h = (Heading)node;
                if (h.getLevel() <= 2) {
                    throw new IllegalArgumentException("Unexpected heading");
                }
                if (this.urgency == null && h.getLevel() == 3 && KeepChangelogParser.SECURITY_HEADER.equalsIgnoreCase(MarkdownUtils.extractText((Node)h).trim())) {
                    this.urgency = ChangeSet.Urgency.high;
                } else if (h.getLevel() == 3 && KeepChangelogParser.RELEASE_HEADER.equalsIgnoreCase(MarkdownUtils.extractText((Node)h).trim())) {
                    return this.readReleaseDetails(h);
                }
            }
            this.nodes.add(node);
            return node.getNext();
        }

        private Node readReleaseDetails(Heading heading) {
            ArrayList<Heading> details = new ArrayList<Heading>(Collections.singleton(heading));
            for (Node n = heading.getNext(); n != null; n = n.getNext()) {
                if (n instanceof Heading) {
                    if (details.size() > 1) {
                        this.nodes.addAll(details);
                    }
                    return n;
                }
                if (n instanceof BulletList) {
                    boolean skip = true;
                    for (Node item = n.getFirstChild(); item != null; item = item.getNext()) {
                        if (!(item.getFirstChild() instanceof Paragraph)) continue;
                        Matcher m = COLON_PAIR.matcher(MarkdownUtils.extractText(item.getFirstChild()));
                        if (m.matches()) {
                            switch (m.group(1).trim().toLowerCase()) {
                                case "distribution": {
                                    this.distribution = m.group(2).trim();
                                    break;
                                }
                                case "urgency": {
                                    skip &= this.parseUrgency(m.group(2).trim());
                                    break;
                                }
                                case "maintainer": {
                                    skip &= this.parseMaintainer(m.group(2).trim());
                                    break;
                                }
                                default: {
                                    skip = false;
                                    break;
                                }
                            }
                            continue;
                        }
                        skip = false;
                    }
                    if (skip) continue;
                }
                details.add((Heading)n);
            }
            if (details.size() > 1) {
                this.nodes.addAll(details);
            }
            return null;
        }

        private boolean parseMaintainer(String maintainer) {
            Matcher matcher = MAINTAINER_PARSER.matcher(maintainer);
            if (matcher.matches()) {
                this.maintainer = matcher.group(1);
                this.maintainerEmail = matcher.group(2);
                return true;
            }
            return false;
        }

        private boolean parseUrgency(String urgency) {
            Matcher matcher = URGENCY_PARSER.matcher(urgency);
            if (matcher.matches()) {
                this.urgency = ChangeSet.Urgency.valueOf(matcher.group(1));
                if (matcher.group(2) != null && !matcher.group(2).isEmpty()) {
                    this.urgencyComment = matcher.group(2);
                }
                return true;
            }
            return false;
        }
    }
}

