/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb.changes;

import io.solit.deb.Version;
import io.solit.deb.changes.Changes;
import java.io.IOException;
import java.io.Writer;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.HashMap;
import java.util.Objects;

public class ChangeSet {
    private static final DateTimeFormatter RFC_5322_DATE_TIME;
    private final String packageName;
    private final Version version;
    private final String maintainer;
    private final String maintainerEmail;
    private String distribution = "stable";
    private Urgency urgency = Urgency.medium;
    private String urgencyCommentary;
    private ZonedDateTime date;
    private final Changes changes;

    public ChangeSet(String packageName, Version version, String maintainer, String maintainerEmail, Changes changes) {
        this.packageName = Objects.requireNonNull(packageName, "");
        if (packageName.contains("\n")) {
            throw new IllegalArgumentException("Package name should not contain line feed");
        }
        this.version = Objects.requireNonNull(version);
        this.maintainer = Objects.requireNonNull(maintainer);
        if (maintainer.contains("\n")) {
            throw new IllegalArgumentException("Maintainer should not contain line feed");
        }
        this.maintainerEmail = maintainerEmail;
        if (maintainerEmail.contains("\n")) {
            throw new IllegalArgumentException("Maintainer email should not contain line feed");
        }
        this.date = ZonedDateTime.now();
        this.changes = Objects.requireNonNull(changes, "Changes must not be null");
    }

    public ChangeSet setDate(ZonedDateTime date) {
        this.date = Objects.requireNonNull(date, "Date should not be null");
        return this;
    }

    public ChangeSet setDistribution(String distribution) {
        Objects.requireNonNull(distribution, "Distribution should not be null");
        if (distribution.contains(";") || distribution.contains("\n")) {
            throw new IllegalArgumentException("Distribution should not contain commas and line breaks");
        }
        this.distribution = distribution;
        return this;
    }

    public ChangeSet setUrgency(Urgency urgency) {
        this.urgency = Objects.requireNonNull(urgency, "Urgency should not be null");
        return this;
    }

    public ChangeSet setUrgencyCommentary(String commentary) {
        if (commentary != null && (commentary.contains(",") || commentary.contains("\n"))) {
            throw new IllegalArgumentException("Commentary should not contain commas and line breaks");
        }
        this.urgencyCommentary = commentary;
        return this;
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.packageName);
        writer.write(" (");
        writer.write(this.version.getValidatedString());
        writer.write(")");
        writer.write(" ");
        writer.write(this.distribution);
        writer.write("; urgency=");
        writer.write(this.urgency.toString());
        if (this.urgencyCommentary != null) {
            writer.write(" (");
            writer.write(this.urgencyCommentary);
            writer.write(41);
        }
        writer.write(10);
        for (String change : this.changes) {
            writer.write("  ");
            writer.write(change);
            writer.write(10);
        }
        writer.write(" -- ");
        writer.write(this.maintainer);
        writer.write(" <");
        writer.write(this.maintainerEmail);
        writer.write(">  ");
        writer.write(RFC_5322_DATE_TIME.format(this.date));
    }

    public Urgency getUrgency() {
        return this.urgency;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public String getMaintainerEmail() {
        return this.maintainerEmail;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public String getUrgencyCommentary() {
        return this.urgencyCommentary;
    }

    public ZonedDateTime getDate() {
        return this.date;
    }

    public Changes getChanges() {
        return this.changes;
    }

    static {
        HashMap<Long, String> dow = new HashMap<Long, String>();
        dow.put(1L, "Mon");
        dow.put(2L, "Tue");
        dow.put(3L, "Wed");
        dow.put(4L, "Thu");
        dow.put(5L, "Fri");
        dow.put(6L, "Sat");
        dow.put(7L, "Sun");
        HashMap<Long, String> moy = new HashMap<Long, String>();
        moy.put(1L, "Jan");
        moy.put(2L, "Feb");
        moy.put(3L, "Mar");
        moy.put(4L, "Apr");
        moy.put(5L, "May");
        moy.put(6L, "Jun");
        moy.put(7L, "Jul");
        moy.put(8L, "Aug");
        moy.put(9L, "Sep");
        moy.put(10L, "Oct");
        moy.put(11L, "Nov");
        moy.put(12L, "Dec");
        RFC_5322_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, dow).appendLiteral(", ").optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(' ').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, moy).appendLiteral(' ').appendValue(ChronoField.YEAR, 4).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().appendLiteral(' ').appendOffset("+HHMM", "+0000").toFormatter();
    }

    public static enum Urgency {
        low,
        medium,
        high,
        emergency,
        critical;

    }
}

