/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb;

import java.util.ArrayDeque;
import org.commonmark.node.Code;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.Text;

public class MarkdownUtils {
    public static String extractText(Node node) {
        ArrayDeque<Node> nodes = new ArrayDeque<Node>();
        StringBuilder builder = new StringBuilder();
        Node n = node;
        while (n != null) {
            Link l;
            if (n instanceof Text) {
                builder.append(((Text)Text.class.cast(n)).getLiteral());
            }
            if (n instanceof Code) {
                builder.append(((Code)Code.class.cast(n)).getLiteral());
            }
            if (n instanceof Link && (l = (Link)n).getFirstChild() == null) {
                if (l.getTitle() != null) {
                    builder.append(l.getTitle());
                } else if (l.getDestination() != null) {
                    builder.append(l.getDestination());
                }
            }
            if (n instanceof SoftLineBreak || n instanceof HardLineBreak) {
                builder.append(" ");
            }
            if (n instanceof HtmlInline) {
                builder.append(((HtmlInline)HtmlInline.class.cast(n)).getLiteral());
            }
            for (Node c = n.getLastChild(); c != null; c = c.getPrevious()) {
                nodes.push(c);
            }
            n = (Node)nodes.poll();
        }
        return builder.toString();
    }
}

