/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class DebFileWriter
implements AutoCloseable {
    private static final String AR_HEADER = "!<arch>\n";
    private static final String DEB_VERSION = "2.0";
    private static final int BEFORE_CONTROL_STAGE = 2;
    private static final int BEFORE_DATA_SAGE = 4;
    private static final int FINAL_STAGE = 6;
    private static final int HEADER_LENGTH = 60;
    private static final int FILENAME_LENGTH = 16;
    private static final int MOD_TIME_LENGTH = 12;
    private static final long SIZE_OFFSET = 48L;
    private static final String OWNER_ID = "0     ";
    private static final String GROUP_ID = "0     ";
    private static final String FILE_MODE = "100644  ";
    private static final String SIZE_PLACEHOLDER = "          ";
    private static final Charset CHARSET = StandardCharsets.ISO_8859_1;
    private final RandomAccessFile _randomAccessFile;
    private int _stage;

    public DebFileWriter(File file) throws IOException {
        this._randomAccessFile = new RandomAccessFile(file, "rw");
        this._randomAccessFile.write(AR_HEADER.getBytes(CHARSET));
        try (OutputStreamWriter os = new OutputStreamWriter((OutputStream)new DebOutputStream("debian-binary", "debian-binary"), CHARSET);){
            os.write("2.0\n");
        }
    }

    public TarArchiveOutputStream openControl() throws IOException {
        if (this._stage != 2) {
            throw new IOException("Control stream was previously open");
        }
        TarArchiveOutputStream control = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new DebOutputStream("control", "control.tar.gz")), StandardCharsets.UTF_8.name());
        control.setLongFileMode(2);
        return control;
    }

    public TarArchiveOutputStream openData() throws IOException {
        if (this._stage != 4) {
            throw new IOException("Data stream was previously open");
        }
        TarArchiveOutputStream data = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new DebOutputStream("data", "data.tar.gz")), StandardCharsets.UTF_8.name());
        data.setLongFileMode(2);
        return data;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this._stage > 16) {
                return;
            }
            if (this._stage < 6) {
                throw new IOException("Deb file is incomplete");
            }
            ++this._stage;
        }
        finally {
            this._randomAccessFile.close();
        }
    }

    private class DebOutputStream
    extends OutputStream {
        private final long _startOffset;
        private final int _activeState;
        private final String _name;

        public DebOutputStream(String name, String fileName) throws IOException {
            this._activeState = ++DebFileWriter.this._stage;
            this._startOffset = DebFileWriter.this._randomAccessFile.getFilePointer();
            ByteArrayOutputStream buffer = this.createHeader(fileName);
            buffer.writeTo(this);
            this._name = name;
        }

        private ByteArrayOutputStream createHeader(String fileName) throws IOException {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(60);
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)buffer, CHARSET);){
                w.write(fileName);
                for (int i = fileName.length(); i < 16; ++i) {
                    ((Writer)w).write(32);
                }
                String modTime = Long.toString(Instant.now().getEpochSecond());
                w.write(modTime);
                for (int i = modTime.length(); i < 12; ++i) {
                    ((Writer)w).write(32);
                }
                w.write("0     ");
                w.write("0     ");
                w.write(DebFileWriter.FILE_MODE);
                w.write(DebFileWriter.SIZE_PLACEHOLDER);
            }
            buffer.write(96);
            buffer.write(10);
            return buffer;
        }

        private void checkStage() throws IOException {
            if (DebFileWriter.this._stage != this._activeState) {
                throw new IOException("Unable to write to " + this._name + ", since it was previously closed");
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.checkStage();
            DebFileWriter.this._randomAccessFile.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.checkStage();
            DebFileWriter.this._randomAccessFile.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.checkStage();
            DebFileWriter.this._randomAccessFile.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (DebFileWriter.this._stage != this._activeState) {
                return;
            }
            long offset = DebFileWriter.this._randomAccessFile.getFilePointer();
            long size = offset - this._startOffset - 60L;
            if (size % 2L != 0L) {
                this.write(10);
                offset = DebFileWriter.this._randomAccessFile.getFilePointer();
            }
            DebFileWriter.this._randomAccessFile.seek(this._startOffset + 48L);
            if (size >= 10000000000L) {
                throw new IOException("Content size too large: " + size);
            }
            DebFileWriter.this._randomAccessFile.write(Long.toString(size).getBytes(CHARSET));
            DebFileWriter.this._randomAccessFile.seek(offset);
            DebFileWriter.this._stage++;
        }
    }
}

