/*
 * Decompiled with CFR 0.152.
 */
package io.solit.plugin.maven.deb.pack;

import io.solit.deb.Control;
import io.solit.deb.DebFileWriter;
import io.solit.deb.Version;
import io.solit.plugin.maven.deb.pack.Attributes;
import io.solit.plugin.maven.deb.pack.Link;
import io.solit.plugin.maven.deb.pack.PermissionModification;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.Charsets;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE)
public class PackageMojo
extends AbstractMojo {
    private static final String UNIX_SEPARATOR = "/";
    private static final String SNAPSHOT = "-SNAPSHOT";
    @Parameter
    private Set<String> maintainerScripts = new HashSet<String>(Arrays.asList("preinst", "postinst", "prerm", "postrm", "config"));
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File buildDir;
    @Parameter(defaultValue="${project.build.directory}/deb")
    private File stageDir;
    @Parameter(defaultValue="${project.build.directory}/control")
    private File controlDir;
    @Parameter
    private File target;
    @Parameter(property="deb.name", defaultValue="${project.artifactId}")
    private String packageName;
    @Parameter(property="deb.version", defaultValue="${project.version}")
    private String version;
    @Parameter(property="deb.revision")
    private String revision;
    @Parameter(property="deb.maintainer", defaultValue="${project.developers[0].name}")
    private String maintainer;
    @Parameter(property="deb.maintainer", defaultValue="${project.developers[0].email}")
    private String maintainerEmail;
    @Parameter(property="deb.architecture", defaultValue="all")
    private String architecture = "all";
    @Parameter(property="deb.synopsis", defaultValue="${project.name}")
    private String synopsis;
    @Parameter(defaultValue="${project.description}")
    private String description;
    @Parameter(defaultValue="${project.url}")
    private String homepage;
    @Parameter
    private List<PermissionModification> permissions;
    @Parameter
    private Attributes packageAttributes;
    @Parameter
    private List<Link> symbolicLinks;

    private List<PermissionModification> getPermissions() {
        if (this.permissions == null) {
            this.permissions = new ArrayList<PermissionModification>();
        }
        return this.permissions;
    }

    private TarArchiveEntry createTarEntry(String name) {
        TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(name);
        tarArchiveEntry.setMode(33188);
        tarArchiveEntry.setUserId(0);
        tarArchiveEntry.setGroupId(0);
        return tarArchiveEntry;
    }

    private void copyDataFiles(final TarArchiveOutputStream dataArchive) throws IOException {
        final Path start = this.stageDir.toPath();
        final List permissions = this.getPermissions().stream().map(PermissionModification::compile).collect(Collectors.toList());
        SimpleFileVisitor<Path> fv = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                PermissionModification.CompiledPermissions p;
                if (Files.isSameFile(dir, start)) {
                    return FileVisitResult.CONTINUE;
                }
                Path relative = start.relativize(dir);
                TarArchiveEntry entry = new TarArchiveEntry(relative.toString() + PackageMojo.UNIX_SEPARATOR, 53);
                entry.setIds(0, 0);
                entry.setModTime(16877L);
                entry.setSize(0L);
                entry.setModTime(attrs.lastModifiedTime().toMillis());
                Iterator iterator = permissions.iterator();
                while (iterator.hasNext() && !(p = (PermissionModification.CompiledPermissions)iterator.next()).apply(entry, relative)) {
                }
                dataArchive.putArchiveEntry((ArchiveEntry)entry);
                dataArchive.closeArchiveEntry();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                PermissionModification.CompiledPermissions p;
                if (attrs.isSymbolicLink()) {
                    return FileVisitResult.CONTINUE;
                }
                Path relative = start.relativize(file);
                TarArchiveEntry entry = PackageMojo.this.createTarEntry(relative.toString());
                entry.setSize(attrs.size());
                entry.setModTime(attrs.lastModifiedTime().toMillis());
                Iterator iterator = permissions.iterator();
                while (iterator.hasNext() && !(p = (PermissionModification.CompiledPermissions)iterator.next()).apply(entry, relative)) {
                }
                dataArchive.putArchiveEntry((ArchiveEntry)entry);
                IOUtils.copy((InputStream)new FileInputStream(file.toFile()), (OutputStream)dataArchive);
                dataArchive.closeArchiveEntry();
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(start, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)fv);
    }

    private void writeLinks() {
        if (this.symbolicLinks == null || this.symbolicLinks.isEmpty()) {
            return;
        }
        for (Link lnk : this.symbolicLinks) {
            if (lnk.getLinkName() == null || lnk.getLinkName().trim().isEmpty()) {
                throw new IllegalArgumentException("Link name is not specified");
            }
            if (lnk.getLinkDestination() == null || lnk.getLinkDestination().trim().isEmpty()) {
                throw new IllegalArgumentException("Link destination is not specified");
            }
            TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(lnk.getLinkName().trim(), 50);
            tarArchiveEntry.setUserId(0);
            tarArchiveEntry.setGroupId(0);
            tarArchiveEntry.setSize(0L);
            tarArchiveEntry.setMode(41471);
            tarArchiveEntry.setLinkName(lnk.getLinkDestination().trim());
        }
    }

    private Control createControl() {
        String maintainer;
        String version = this.version;
        String revision = this.revision;
        if (revision == null && version.endsWith(SNAPSHOT)) {
            version = version.substring(0, version.length() - SNAPSHOT.length());
            revision = "b" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        }
        if ((maintainer = this.maintainer) == null) {
            throw new IllegalArgumentException("Maintainer should be specified");
        }
        if (this.maintainerEmail != null) {
            maintainer = maintainer + " <" + this.maintainerEmail + ">";
        }
        Control control = new Control(this.packageName, new Version(version, revision), maintainer, this.architecture, this.synopsis);
        control.setDescription(this.processDescription());
        if (this.packageAttributes != null) {
            this.packageAttributes.fillControl(control);
        }
        if (this.homepage != null) {
            control.setHomepage(this.homepage);
        }
        return control;
    }

    private String processDescription() {
        if (this.description == null || this.description.trim().isEmpty()) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        int maxWhitespaces = Integer.MAX_VALUE;
        Scanner scanner = new Scanner(this.description);
        StringBuilder result = new StringBuilder(this.description.length());
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (result.length() == 0) {
                result.append(line.trim()).append('\n');
                continue;
            }
            int ws = this.countWhitespaces(line);
            if (ws < line.length()) {
                maxWhitespaces = Math.min(maxWhitespaces, ws);
            }
            lines.add(line);
        }
        for (String line : lines) {
            if (line.length() <= maxWhitespaces) continue;
            result.append(line.substring(maxWhitespaces)).append('\n');
        }
        return result.toString();
    }

    private int countWhitespaces(String line) {
        for (int i = 0; i < line.length(); ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            return i;
        }
        return 0;
    }

    private void copyControlFiles(final TarArchiveOutputStream controlArchive) throws IOException {
        final Path start = this.controlDir.toPath();
        SimpleFileVisitor<Path> fv = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                TarArchiveEntry entry = PackageMojo.this.createTarEntry(start.relativize(file).toString());
                entry.setSize(attrs.size());
                if (PackageMojo.this.maintainerScripts.contains(entry.getName())) {
                    entry.setMode(33261);
                }
                entry.setModTime(attrs.lastModifiedTime().toMillis());
                controlArchive.putArchiveEntry((ArchiveEntry)entry);
                IOUtils.copy((InputStream)new FileInputStream(file.toFile()), (OutputStream)controlArchive);
                controlArchive.closeArchiveEntry();
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(start, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)fv);
    }

    private void writeControl(TarArchiveOutputStream controlArchive, Control control) throws IOException {
        TarArchiveEntry entry = this.createTarEntry("control");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (OutputStreamWriter wr = new OutputStreamWriter((OutputStream)buffer, Charsets.UTF_8);){
            control.writeControlFile(wr);
        }
        entry.setSize((long)buffer.size());
        controlArchive.putArchiveEntry((ArchiveEntry)entry);
        buffer.writeTo((OutputStream)controlArchive);
        controlArchive.closeArchiveEntry();
    }

    private long writeCheckSumsAndComputeSize(TarArchiveOutputStream controlArchive) throws IOException {
        long size;
        TarArchiveEntry entry = this.createTarEntry("md5sums");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (OutputStreamWriter wr = new OutputStreamWriter((OutputStream)buffer, Charsets.UTF_8);){
            size = this.writeCheckSumsAndComputeSize(wr);
        }
        entry.setSize((long)buffer.size());
        controlArchive.putArchiveEntry((ArchiveEntry)entry);
        buffer.writeTo((OutputStream)controlArchive);
        controlArchive.closeArchiveEntry();
        return size;
    }

    private long writeCheckSumsAndComputeSize(final Writer writer) throws IOException {
        final Path start = this.stageDir.toPath();
        final LongAdder adder = new LongAdder();
        SimpleFileVisitor<Path> fv = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (attrs.isSymbolicLink()) {
                    return FileVisitResult.CONTINUE;
                }
                adder.add(attrs.size());
                try (DigestInputStream dis = new DigestInputStream(new FileInputStream(file.toFile()), MessageDigest.getInstance("MD5"));){
                    byte[] buffer = new byte[8192];
                    while (dis.read(buffer) >= 0) {
                    }
                    for (byte b : dis.getMessageDigest().digest()) {
                        int s = b & 0xFF;
                        if (s < 16) {
                            writer.write(48);
                        }
                        writer.write(Integer.toHexString(s));
                    }
                    writer.write(32);
                    String prefix = "";
                    for (Path p : start.relativize(file)) {
                        writer.write(prefix);
                        writer.write(p.toString());
                        prefix = PackageMojo.UNIX_SEPARATOR;
                    }
                    writer.write(10);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("Unable to create md5 digest", e);
                }
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(start, (FileVisitor<? super Path>)fv);
        return adder.longValue();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Control control = this.createControl();
            File target = this.target;
            if (target == null) {
                String targetName = control.getPackageName() + "_" + control.getVersion().getValidatedString() + "_" + control.getArchitecture() + ".deb";
                target = new File(this.buildDir, targetName);
            }
            try (DebFileWriter deb = new DebFileWriter(target);){
                try (TarArchiveOutputStream controlArchive = deb.openControl();){
                    long size = this.writeCheckSumsAndComputeSize(controlArchive);
                    control.setInstalledSize(size);
                    this.writeControl(controlArchive, control);
                    this.copyControlFiles(controlArchive);
                }
                var6_10 = null;
                try (TarArchiveOutputStream dataArchive = deb.openData();){
                    this.copyDataFiles(dataArchive);
                    this.writeLinks();
                }
                catch (Throwable throwable) {
                    var6_10 = throwable;
                    throw throwable;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write directory", (Exception)e);
        }
    }
}

