/*
 * Decompiled with CFR 0.152.
 */
package io.solit.plugin.maven.deb.copyright;

import io.solit.deb.copyright.Copyright;
import io.solit.deb.copyright.CopyrightFiles;
import io.solit.plugin.maven.deb.copyright.CopyrightPatterns;
import io.solit.plugin.maven.deb.copyright.LicenceFile;
import io.solit.plugin.maven.deb.dependencies.AbstractDependencyMojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.time.Year;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.compress.utils.Charsets;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.License;
import org.apache.maven.model.Organization;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="copyright", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class CopyrightMojo
extends AbstractDependencyMojo<Copyright> {
    @Parameter(defaultValue="${project.artifactId}")
    private String upstreamName;
    @Parameter(defaultValue="${project.url}")
    private Set<String> upstreamContact;
    @Parameter(defaultValue="${project.scm.url}")
    private String source;
    @Parameter
    private String copyrightDisclaimer;
    @Parameter
    private String copyrightComment;
    @Parameter
    private String mainLicence;
    @Parameter
    private String copyrightText;
    @Parameter
    private List<CopyrightPatterns> copyrightPatterns;
    @Parameter
    private List<LicenceFile> licesnces;
    @Parameter
    private File copyrightFile;
    @Parameter(readonly=true, defaultValue="${project.build.sourceEncoding}")
    private String sourceEncoding;
    @Parameter
    private Boolean dependencyCopyrights;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File copyrightFile = this.copyrightFile;
            if (copyrightFile == null) {
                if (this.stageDir == null || this.packageName == null) {
                    throw new IllegalArgumentException("Copyright file should be specified");
                }
                copyrightFile = this.stageDir;
                for (String s : new String[]{"usr", "share", "doc", this.packageName, "copyright"}) {
                    copyrightFile = new File(copyrightFile, s);
                }
            }
            Copyright copyright = this.createCopyright();
            this.fillCopyright(copyright);
            this.addLicences(copyright);
            if (Boolean.TRUE.equals(this.dependencyCopyrights)) {
                this.traverseDependencies(copyright);
            }
            if (!copyrightFile.getParentFile().isDirectory() && !copyrightFile.getParentFile().mkdirs()) {
                throw new IOException("Unable to create directories " + copyrightFile.getParentFile());
            }
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(copyrightFile), Charsets.UTF_8);){
                copyright.writeCopyright(writer);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create copyright " + e.getMessage(), (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Configuration error " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void processDependency(AbstractDependencyMojo.DependencyArtifact node, Copyright copyright, File dependencyDir, boolean root) {
        if (root) {
            return;
        }
        if (node.getArtifact().getFile() == null) {
            return;
        }
        Path dependencyFile = new File(dependencyDir, node.getArtifact().getFile().getName()).toPath();
        String file = StreamSupport.stream(this.stageDir.toPath().relativize(dependencyFile).spliterator(), false).map(Object::toString).collect(Collectors.joining("/", "/", ""));
        MavenProject project = node.getProject();
        String cpr = this.getProjectCopyright(project);
        if (cpr == null) {
            return;
        }
        block0: for (License l : project.getLicenses()) {
            if (l.getName() == null || l.getName().isEmpty()) continue;
            for (CopyrightFiles f : copyright.getFiles()) {
                if (!f.getLicence().equals(l.getName()) || !f.getCopyright().equals(cpr)) continue;
                if (f.getFiles().contains("*")) continue block0;
                f.addFile(file);
                continue block0;
            }
            copyright.addFiles(Collections.singleton(file), cpr, l.getName());
        }
    }

    private void fillCopyright(Copyright copyright) {
        copyright.setComment(this.copyrightComment);
        copyright.setLicence(this.mainLicence);
        copyright.setDisclaimer(this.copyrightDisclaimer);
        if (this.copyrightText != null) {
            copyright.setCopyright(this.copyrightText);
        }
        copyright.setUpstreamName(this.upstreamName);
        copyright.setSource(this.source);
        if (this.upstreamContact != null) {
            this.upstreamContact.forEach(copyright::addUpstreamContact);
        }
    }

    private void addLicences(Copyright copyright) throws IOException {
        if (this.licesnces != null) {
            for (LicenceFile l : this.licesnces) {
                l.addToCopyright(this.sourceEncoding, copyright);
            }
        }
    }

    private Copyright createCopyright() {
        Copyright copyright;
        if (this.copyrightPatterns == null || this.copyrightPatterns.isEmpty()) {
            String cpr = this.copyrightText;
            if (cpr == null) {
                cpr = this.getProjectCopyright(this.project);
            }
            if (cpr == null || cpr.isEmpty()) {
                cpr = System.getProperty("user.name");
            }
            if (this.mainLicence != null && this.mainLicence.isEmpty()) {
                copyright = new Copyright(Collections.singleton("*"), cpr, this.mainLicence);
                copyright.setCopyright(cpr);
            } else if (!this.project.getLicenses().isEmpty()) {
                Iterator licenses = this.project.getLicenses().iterator();
                copyright = new Copyright(Collections.singleton("*"), cpr, ((License)licenses.next()).getName());
                copyright.setCopyright(cpr);
                while (licenses.hasNext()) {
                    copyright.addFiles(Collections.singleton("*"), cpr, ((License)licenses.next()).getName());
                }
            } else {
                copyright = new Copyright(Collections.singleton("*"), cpr, "public-domain");
            }
        } else {
            Iterator<CopyrightPatterns> iterator = this.copyrightPatterns.iterator();
            CopyrightPatterns p = iterator.next();
            copyright = new Copyright(p.getFiles(), p.getCopyright(), p.getLicence(), p.getComment(), p.getLicenceContent());
            while (iterator.hasNext()) {
                p = iterator.next();
                CopyrightFiles files = copyright.addFiles(p.getFiles(), p.getCopyright(), p.getLicence());
                files.setLicenceContent(p.getLicenceContent());
                files.setComment(p.getComment());
            }
        }
        return copyright;
    }

    private String getProjectCopyright(MavenProject project) {
        String cpr;
        block9: {
            String prefix;
            block8: {
                block7: {
                    block6: {
                        prefix = project.getInceptionYear() != null ? "\u00a9 " + project.getInceptionYear() + "-" + Year.now().getValue() + " " : "\u00a9 " + Year.now().getValue() + " ";
                        cpr = Optional.of(project).map(MavenProject::getOrganization).map(Organization::getName).map(prefix::concat).orElse(null);
                        if (cpr == null) break block6;
                        if (!cpr.isEmpty()) break block7;
                    }
                    cpr = project.getDevelopers().stream().map(Contributor::getName).map(String::trim).filter(s -> !s.isEmpty()).map(prefix::concat).collect(Collectors.joining("\n"));
                }
                if (cpr == null) break block8;
                if (!cpr.isEmpty()) break block9;
            }
            cpr = project.getContributors().stream().map(Contributor::getName).map(String::trim).filter(s -> !s.isEmpty()).map(prefix::concat).collect(Collectors.joining("\n"));
        }
        return cpr;
    }
}

