/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb;

import java.util.regex.Pattern;

public class Version {
    public static final Pattern REVISION_PATTERN = Pattern.compile("^[\\w+.~]+");
    private Integer epoch;
    private String upstream;
    private String revision;

    Version() {
    }

    public Version(Integer epoch, String upstream, String revision) {
        this.epoch = epoch;
        this.upstream = upstream;
        this.revision = revision;
    }

    public Version(String upstream) {
        this.upstream = upstream;
    }

    public Version(String upstream, String revision) {
        this.upstream = upstream;
        this.revision = revision;
    }

    public Integer getEpoch() {
        return this.epoch;
    }

    public String getUpstream() {
        return this.upstream;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getValidatedString() {
        StringBuilder result = new StringBuilder();
        if (this.epoch != null) {
            if (this.epoch < 0) {
                throw new IllegalArgumentException("Epoch should be an unsigned integer");
            }
            result.append(this.epoch).append(":");
        }
        if (this.upstream == null || this.upstream.trim().isEmpty()) {
            throw new IllegalArgumentException("Upstream version should be specified");
        }
        if (!Character.isDigit(this.upstream.charAt(0))) {
            throw new IllegalArgumentException("Upstream should start with a digit, was '" + this.upstream + "'");
        }
        Version.checkUpstream(this.upstream, this.revision);
        result.append(this.upstream);
        if (this.revision != null) {
            if (!REVISION_PATTERN.matcher(this.revision).matches()) {
                throw new IllegalArgumentException("Revision should match " + REVISION_PATTERN.pattern());
            }
            result.append("-").append(this.revision);
        }
        return result.toString();
    }

    public static Version parseVersion(String versionString) {
        int hyphen;
        Integer epoch = null;
        String upstream = versionString;
        String revision = null;
        int colon = upstream.indexOf(58);
        if (colon >= 0) {
            try {
                epoch = Integer.valueOf(versionString.substring(0, colon));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("'" + versionString + "' is not a valid version");
            }
            if (epoch < 0) {
                throw new IllegalArgumentException("'" + versionString + "' is not a valid version");
            }
            upstream = upstream.substring(colon + 1);
        }
        if ((hyphen = upstream.lastIndexOf(45)) >= 0) {
            revision = upstream.substring(hyphen + 1);
            if (!REVISION_PATTERN.matcher(revision).matches()) {
                throw new IllegalArgumentException("'" + versionString + "' is not a valid version");
            }
            upstream = upstream.substring(0, hyphen);
        }
        Version.checkUpstream(upstream, revision);
        return new Version(epoch, upstream, revision);
    }

    private static void checkUpstream(String upstream, String revision) {
        int l = upstream.length();
        block4: for (int i = 1; i < l; ++i) {
            if (Character.isAlphabetic(upstream.charAt(i)) || Character.isDigit(upstream.charAt(i))) continue;
            switch (upstream.charAt(i)) {
                case '+': 
                case '.': 
                case '~': {
                    continue block4;
                }
                case '-': {
                    if (revision != null) continue block4;
                    throw new IllegalArgumentException("If revision is not specified upstream should not contain hyphens, was '" + upstream + "'");
                }
                default: {
                    throw new IllegalArgumentException("Upstream should consist of alphanumeric characters, '+', '.', '~' and '-' if revision is specified, was '" + upstream + "'");
                }
            }
        }
    }
}

