/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Objects;

public class ControlFileWriter
implements AutoCloseable {
    private static final String COMMA_ITEMS_SEPARATOR = ", ";
    private static final String WS_ITEMS_SEPARATOR = " ";
    private static final String VALUE_SEPARATOR = ": ";
    private static final char FIELD_SEPARATOR = '\n';
    private static final String CONTINUATION_SEPARATOR = "\n ";
    private static final int MAX_LINE_LENGTH = 80;
    private final Writer writer;

    public ControlFileWriter(Writer writer) {
        this.writer = Objects.requireNonNull(writer, "Writer should not be null");
    }

    public void nextParagraph() throws IOException {
        this.writer.write("\n");
    }

    public void writeSingleLineField(String field, String value) throws IOException {
        this.writer.write(field);
        this.writer.write(VALUE_SEPARATOR);
        this.writer.write(value);
        this.writer.write(10);
    }

    public void writeSingleLineList(String field, Iterable<String> values) throws IOException {
        this.writer.write(field);
        String pref = VALUE_SEPARATOR;
        for (String val : values) {
            this.writer.write(pref);
            this.writer.write(val);
            pref = COMMA_ITEMS_SEPARATOR;
        }
        this.writer.write(10);
    }

    public void writeMultiLineList(String field, Iterable<String> values) throws IOException {
        this.writer.write(field);
        this.writer.write(VALUE_SEPARATOR);
        int length = field.length() + VALUE_SEPARATOR.length();
        String pref = "";
        for (String val : values) {
            if (length + pref.length() + val.length() < 80) {
                this.writer.write(pref);
                this.writer.write(val);
                length += pref.length() + val.length();
            } else {
                this.writer.write(CONTINUATION_SEPARATOR);
                this.writer.write(val);
                length = val.length() + 1;
            }
            pref = WS_ITEMS_SEPARATOR;
        }
        this.writer.write(10);
    }

    public void writeLineBasedList(String field, Iterable<String> values) throws IOException {
        this.writer.write(field);
        this.writer.write(VALUE_SEPARATOR);
        Iterator<String> it = values.iterator();
        while (it.hasNext()) {
            String item = it.next();
            this.writer.write(item);
            if (!it.hasNext()) continue;
            this.writer.write(CONTINUATION_SEPARATOR);
        }
        this.writer.write(10);
    }

    public void writeFormattedField(String field, String synopsis, String content) throws IOException {
        this.writer.write(field);
        this.writer.write(VALUE_SEPARATOR);
        if (synopsis != null) {
            this.writer.write(synopsis);
            this.writer.write(10);
        }
        if (content != null) {
            char[] chars = content.toCharArray();
            int last = 0;
            boolean nonSpaces = false;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == '\n') {
                    if (i >= last) {
                        this.writer.write(32);
                        if (nonSpaces) {
                            this.writer.write(chars, last, i - last + 1);
                        } else {
                            this.writer.write(46);
                            this.writer.write(10);
                        }
                    }
                    last = i + 1;
                    nonSpaces = false;
                    continue;
                }
                if (nonSpaces || Character.isWhitespace(chars[i])) continue;
                nonSpaces = true;
            }
            if (last < chars.length && nonSpaces) {
                this.writer.write(32);
                this.writer.write(chars, last, chars.length - last);
            }
            this.writer.write(10);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

