/*
 * Decompiled with CFR 0.152.
 */
package io.solit.deb;

import io.solit.deb.ControlFileWriter;
import io.solit.deb.PackagePriority;
import io.solit.deb.Version;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Control {
    private static final String PACKAGE_HEADER = "Package";
    private static final String VERSION_HEADER = "Version";
    private static final String SECTION_HEADER = "Section";
    private static final String PRIORITY_HEADER = "Priority";
    private static final String ARCHITECTURE_HEADER = "Architecture";
    private static final String MAINTAINER_HEADER = "Maintainer";
    private static final String DESCRIPTION_HEADER = "Description";
    private static final String SOURCE_HEADER = "Source";
    private static final String ESSENTIAL_HEADER = "Essential";
    private static final String INSTALLED_SIZE_HEADER = "Installed-Size";
    private static final String HOMEPAGE_HEADER = "Homepage";
    private static final String BUILT_USING_HEADER = "Built-Using";
    private static final String DEPENDS_HEADER = "Depends";
    private static final String PRE_DEPENDS_HEADER = "Pre-Depends";
    private static final String RECOMMENDS_HEADER = "Recommends";
    private static final String SUGGESTS_HEADER = "Suggests";
    private static final String ENHANCES_HEADER = "Enhances";
    private static final String BREAKS_HEADER = "Breaks";
    private static final String CONFLICTS_HEADER = "Conflicts";
    private static final String PROVIDES_HEADER = "Provides";
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("^[a-z0-9][a-z0-9+.-]+$");
    private static final Pattern PACKAGE_REFERENCE = Pattern.compile("^[a-z0-9][a-z0-9+.-]+(?:\\s*\\(([^)]+)\\))?$");
    private static final List<String> VERSION_RELATIONS = Collections.unmodifiableList(Arrays.asList("<<", "<=", "=", ">=", ">>"));
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private final Map<String, Set<String>> relationshipHeaders = new HashMap<String, Set<String>>();
    private final Version version;
    private final String synopsis;
    private String description;

    public Control(String packageName, Version version, String maintainer, String architecture, String synopsis) {
        if (!PACKAGE_PATTERN.matcher(Objects.requireNonNull(packageName, "Package name should not be null")).matches()) {
            throw new IllegalArgumentException("Package name should match '" + PACKAGE_PATTERN.pattern() + "', was '" + packageName + "'");
        }
        if (Objects.requireNonNull(architecture, "Architecture should not be null").trim().isEmpty()) {
            throw new IllegalArgumentException("Architecture should not be blank");
        }
        if (Objects.requireNonNull(maintainer, "Maintainer should not be null").trim().isEmpty()) {
            throw new IllegalArgumentException("Maintainer should not be blank");
        }
        if (Objects.requireNonNull(synopsis, "Synopsis should not be null").trim().isEmpty()) {
            throw new IllegalArgumentException("Synopsis should not be blank");
        }
        this.headers.put(PACKAGE_HEADER, packageName);
        this.version = Objects.requireNonNull(version, "Version should not be null");
        this.headers.put(VERSION_HEADER, version.getValidatedString());
        this.headers.put(MAINTAINER_HEADER, maintainer.trim());
        this.headers.put(ARCHITECTURE_HEADER, architecture.trim());
        this.synopsis = Objects.requireNonNull(synopsis, "Synopsis should not be null");
    }

    public String getPackageName() {
        return this.headers.get(PACKAGE_HEADER);
    }

    public Version getVersion() {
        return this.version;
    }

    public String getMaintainer() {
        return this.headers.get(MAINTAINER_HEADER);
    }

    public String getArchitecture() {
        return this.headers.get(ARCHITECTURE_HEADER);
    }

    public String getSource() {
        return this.headers.get(SOURCE_HEADER);
    }

    public void setSource(String source) {
        if (source == null || source.isEmpty()) {
            this.headers.remove(SOURCE_HEADER);
        } else if (PACKAGE_PATTERN.matcher(source).matches()) {
            this.headers.put(SOURCE_HEADER, source);
        } else {
            throw new IllegalArgumentException("Source package name should match " + PACKAGE_PATTERN.pattern());
        }
    }

    public String getSection() {
        return this.headers.get(SECTION_HEADER);
    }

    public void setSection(String section) {
        if (section == null || section.isEmpty()) {
            this.headers.remove(SECTION_HEADER);
        } else {
            this.headers.put(SECTION_HEADER, section);
        }
    }

    public PackagePriority getPriority() {
        return Optional.ofNullable(this.headers.get(PRIORITY_HEADER)).map(PackagePriority::valueOf).orElse(null);
    }

    public void setPriority(PackagePriority priority) {
        if (priority == null) {
            this.headers.remove(PRIORITY_HEADER);
        } else {
            this.headers.put(PRIORITY_HEADER, priority.name());
        }
    }

    public Boolean getEssential() {
        return Optional.ofNullable(this.headers.get(ESSENTIAL_HEADER)).map(Boolean::valueOf).orElse(null);
    }

    public void setEssential(Boolean essential) {
        if (essential == null) {
            this.headers.remove(ESSENTIAL_HEADER);
        } else {
            this.headers.put(ESSENTIAL_HEADER, essential != false ? "yes" : "no");
        }
    }

    public Long getInstalledSize() {
        return Optional.ofNullable(this.headers.get(INSTALLED_SIZE_HEADER)).map(Long::valueOf).orElse(null);
    }

    public void setInstalledSize(Long installedSizeInBytes) {
        if (installedSizeInBytes == null) {
            this.headers.remove(INSTALLED_SIZE_HEADER);
        } else {
            this.headers.put(INSTALLED_SIZE_HEADER, Long.toString(installedSizeInBytes / 1024L));
        }
    }

    public String getHomepage() {
        return this.headers.get(HOMEPAGE_HEADER);
    }

    public void setHomepage(String homepage) {
        if (homepage == null || homepage.isEmpty()) {
            this.headers.remove(HOMEPAGE_HEADER);
        } else {
            this.headers.put(HOMEPAGE_HEADER, homepage);
        }
    }

    public String getBuildUsing() {
        return this.headers.get(BUILT_USING_HEADER);
    }

    public void setBuildUsing(String buildTool) {
        if (buildTool == null || buildTool.isEmpty()) {
            this.headers.remove(BUILT_USING_HEADER);
        } else {
            this.headers.put(BUILT_USING_HEADER, buildTool);
        }
    }

    private void checkPackageReference(String packageReference) {
        Objects.requireNonNull(packageReference, "Package reference should not be null");
        for (String ref : packageReference.split("\\|")) {
            Matcher matcher = PACKAGE_REFERENCE.matcher(ref.trim());
            if (!matcher.matches()) {
                throw new IllegalArgumentException("'" + packageReference + " is not a valid package reference");
            }
            if (matcher.group(1) == null) continue;
            String versionClause = matcher.group(1).trim();
            String version = null;
            for (String rel : VERSION_RELATIONS) {
                if (!versionClause.startsWith(rel)) continue;
                version = versionClause.substring(rel.length()).trim();
                break;
            }
            if (version == null) {
                throw new IllegalArgumentException("'" + packageReference + "' is not a valid package reference");
            }
            Version.parseVersion(version);
        }
    }

    public void addDepends(String packageReference) {
        this.checkPackageReference(packageReference);
        this.relationshipHeaders.computeIfAbsent(DEPENDS_HEADER, s -> new HashSet()).add(packageReference);
    }

    public Set<String> getPreDepends() {
        return Collections.unmodifiableSet(this.relationshipHeaders.computeIfAbsent(PRE_DEPENDS_HEADER, s -> new HashSet()));
    }

    public void addPreDepends(String packageReference) {
        this.checkPackageReference(packageReference);
        this.relationshipHeaders.computeIfAbsent(PRE_DEPENDS_HEADER, s -> new HashSet()).add(packageReference);
    }

    public Set<String> getRecommends() {
        return Collections.unmodifiableSet(this.relationshipHeaders.computeIfAbsent(RECOMMENDS_HEADER, s -> new HashSet()));
    }

    public void addRecommends(String packageReference) {
        this.checkPackageReference(packageReference);
        this.relationshipHeaders.computeIfAbsent(RECOMMENDS_HEADER, s -> new HashSet()).add(packageReference);
    }

    public Set<String> getSuggests() {
        return Collections.unmodifiableSet(this.relationshipHeaders.computeIfAbsent(SUGGESTS_HEADER, s -> new HashSet()));
    }

    public void addSuggests(String packageReference) {
        this.checkPackageReference(packageReference);
        this.relationshipHeaders.computeIfAbsent(SUGGESTS_HEADER, s -> new HashSet()).add(packageReference);
    }

    public Set<String> getEnhances() {
        return Collections.unmodifiableSet(this.relationshipHeaders.computeIfAbsent(ENHANCES_HEADER, s -> new HashSet()));
    }

    public void addEnhances(String packageReference) {
        this.checkPackageReference(packageReference);
        this.relationshipHeaders.computeIfAbsent(ENHANCES_HEADER, s -> new HashSet()).add(packageReference);
    }

    public Set<String> getBreaks() {
        return Collections.unmodifiableSet(this.relationshipHeaders.computeIfAbsent(BREAKS_HEADER, s -> new HashSet()));
    }

    public void addBreaks(String packageReference) {
        this.checkPackageReference(packageReference);
        this.relationshipHeaders.computeIfAbsent(BREAKS_HEADER, s -> new HashSet()).add(packageReference);
    }

    public Set<String> getConflicts() {
        return Collections.unmodifiableSet(this.relationshipHeaders.computeIfAbsent(CONFLICTS_HEADER, s -> new HashSet()));
    }

    public void addConflicts(String packageReference) {
        this.checkPackageReference(packageReference);
        this.relationshipHeaders.computeIfAbsent(CONFLICTS_HEADER, s -> new HashSet()).add(packageReference);
    }

    public Set<String> getProvides() {
        return Collections.unmodifiableSet(this.relationshipHeaders.computeIfAbsent(PROVIDES_HEADER, s -> new HashSet()));
    }

    public void addProvides(String packageName) {
        if (!PACKAGE_PATTERN.matcher(packageName).matches()) {
            throw new IllegalArgumentException("Provided package name should match '" + PACKAGE_PATTERN.pattern() + "', was '" + packageName + "'");
        }
        this.relationshipHeaders.computeIfAbsent(PROVIDES_HEADER, s -> new HashSet()).add(packageName);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void writeControlFile(Writer writer) throws IOException {
        ControlFileWriter controlWriter = new ControlFileWriter(writer);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            controlWriter.writeSingleLineField(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.relationshipHeaders.entrySet()) {
            controlWriter.writeSingleLineList(entry.getKey(), (Iterable)entry.getValue());
        }
        controlWriter.writeFormattedField(DESCRIPTION_HEADER, this.synopsis, this.description);
    }
}

