package io.solidtech.crash.video;

import java.util.ArrayList;

/**
 * Created by vulpes on 16. 1. 19..
 */
public class ConcurrentQueue<E> {
    private final ArrayList<E> mCollections;

    public ConcurrentQueue() {
        mCollections = new ArrayList<>();
    }

    public synchronized void push(E material) {
        mCollections.add(material);
        notifyAll();
    }

    public synchronized E pop() throws InterruptedException {
        while (mCollections.size() == 0) {
            wait();
        }
        return mCollections.remove(0);
    }

    public synchronized int size() {
        return mCollections.size();
    }
}
