/*
 * Copyright (C) 2016 Dropbeat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.solidtech.crash.utils;

import java.util.HashMap;
import java.util.Map;

import io.solidtech.crash.entities.HttpTransaction;

/**
 * Super simple memory cache used to save temporal data in http transaction.
 */
public class HttpInstantCache {
    private static final Map<String, HttpTransaction> map = new HashMap<String, HttpTransaction>();

    public static void setTransaction(String uid, HttpTransaction transaction) {
        map.put(uid, transaction);
    }

    public static HttpTransaction popTransaction(String uid) {
        HttpTransaction transaction = map.get(uid);
        clear(uid);
        return transaction;
    }

    public static void clear(String uid) {
        map.remove(uid);
    }
}
