package io.solidtech.crash.environments;

import android.app.Activity;
import android.content.Context;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.solidtech.crash.SolidClient;

/**
 * Created by vulpes on 2015. 12. 2..
 */
public class ActivityStackInfo {
    private static final String TAG = ActivityStackInfo.class.getSimpleName();
    private static int sIndex = 0;

    public static ActivityStackInfo create(SolidClient client) {
        return new ActivityStackInfo(client);
    }

    private SolidClient mClient;
    private Map<String, ActivityInfo> mActivities = new HashMap<>();

    private ActivityStackInfo(SolidClient client) {
        mClient = client;
    }

    public synchronized void setActivity(Activity activity, int state) {
        String className = activity.getClass().getName();
        if (state == ActivityInfo.STATE_DESTROYED) {
            mActivities.remove(className);
            return;
        }
        ActivityInfo info = mActivities.get(className);
        if (info == null) {
            info = new ActivityInfo(sIndex++, activity);
            mActivities.put(className, info);
        }
        info.setState(state);
    }

    public synchronized int getSize() {
        return mActivities.size();
    }

    public JSONArray toJSONArray() {
        try {
            JSONArray array = new JSONArray();
            ArrayList<ActivityInfo> activityList = new ArrayList<>(mActivities.values());
            Collections.sort(activityList, new Comparator<ActivityInfo>() {
                @Override
                public int compare(ActivityInfo lhs, ActivityInfo rhs) {
                    return lhs.index - rhs.index;
                }
            });

            for (ActivityInfo info : activityList) {
                array.put(info.toJSONObject());
            }

            return array.length() == 0 ? null : array;
        } catch (JSONException e) {
            return null;
        }
    }
}
