/*
 * Copyright (C) 2015 Dropbeat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.solidtech.crash.entities;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.Map;

import io.solidtech.crash.utils.JsonUtils;

public class HttpTransaction implements Serializable {
    private String url;
    private String httpMethod;
    private Map<String, String> requestHeaders;
    private String requestBody;
    private Long startTime;
    private Long endTime;
    private Long bytesSent;
    private Long bytesReceived;
    private Integer responseCode;
    private Map<String, String> responseHeaders;
    private String responseBody;
    private Map<String, String> additionalParams;

    public HttpTransaction(String url, String httpMethod, Map<String, String> requestHeaders, String requestBody,
                           Long startTime, Long endTime, Long bytesSent, Long bytesReceived,
                           Integer responseCode, Map<String, String> responseHeaders, String responseBody,
                           Map<String, String> additionalParams) {
        this.url = url;
        this.httpMethod = httpMethod;
        this.requestBody = requestBody;
        this.requestHeaders = requestHeaders;
        this.startTime = startTime;
        this.endTime = endTime;
        this.bytesSent = bytesSent;
        this.bytesReceived = bytesReceived;
        this.responseHeaders = responseHeaders;
        this.responseCode = responseCode;
        this.responseBody = responseBody;
        this.additionalParams = additionalParams;
    }

    public JSONObject toJson() {
        try {
            JSONObject obj = new JSONObject();

            // We use crappy method to preserve dict key even if a value is null.
            // TODO: Fix me
            obj.put("url", JsonUtils.wrapNull(url))
               .put("http_method", JsonUtils.wrapNull(httpMethod))
               .put("request_body", JsonUtils.wrapNull(requestBody))
               .put("start_time", JsonUtils.wrapNull(startTime))
               .put("end_time", JsonUtils.wrapNull(endTime))
               .put("bytes_sent", JsonUtils.wrapNull(bytesSent))
               .put("bytes_received", JsonUtils.wrapNull(bytesReceived))
               .put("response_code", JsonUtils.wrapNull(responseCode))
               .put("response_body", JsonUtils.wrapNull(responseBody))
               .put("request_headers", JsonUtils.wrapNull(JsonUtils.mapToJson(requestHeaders)))
               .put("response_headers", JsonUtils.wrapNull(JsonUtils.mapToJson(responseHeaders)))
               .put("additional_params", JsonUtils.wrapNull(JsonUtils.mapToJson(additionalParams)));

            return obj;
        } catch (JSONException e) {
            return null;
        }
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHttpMethod() {
        return httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Map<String, String> getRequestHeaders() {
        return requestHeaders;
    }

    public void setRequestHeaders(Map<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Long getBytesSent() {
        return bytesSent;
    }

    public void setBytesSent(Long bytesSent) {
        this.bytesSent = bytesSent;
    }

    public Long getBytesReceived() {
        return bytesReceived;
    }

    public void setBytesReceived(Long bytesReceived) {
        this.bytesReceived = bytesReceived;
    }

    public Integer getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }

    public Map<String, String> getResponseHeaders() {
        return responseHeaders;
    }

    public void setResponseHeaders(Map<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public String getResponseBody() {
        return responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public Map<String, String> getAdditionalParams() {
        return additionalParams;
    }

    public void setAdditionalParams(Map<String, String> additionalParams) {
        this.additionalParams = additionalParams;
    }
}
