package io.solidtech.crash.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;

import io.solidtech.crash.R;
import io.solidtech.crash.utils.ViewUtils;

/**
 * Created by vulpes on 2015. 11. 30..
 */
public class AnrButton extends Button implements View.OnClickListener {

    public AnrButton(Context context) {
        super(context);
    }

    public AnrButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        initialize(context);
    }

    public AnrButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initialize(context);
    }

    private void initialize(Context context) {
        setText(context.getString(R.string.solid_btn_anr));
        setBackgroundResource(R.drawable.btn);
        setOnClickListener(this);
        int paddingTop = getPaddingTop();
        int paddingBottom = getPaddingBottom();
        int paddingLeft;
        int paddingRight;
        paddingLeft = paddingRight = ViewUtils.dpToPx(context, 20);
        setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    @Override
    public void onClick(View v) {
        while (true) {
        }
    }
}
