package io.solidtech.crash.network;

import android.util.Log;

import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Response;

import org.json.JSONObject;

import java.io.IOException;

/**
 * Created by vulpes on 15. 12. 25..
 */
public abstract class JsonCallback implements Callback {
    @Override
    public void onResponse(Response response) throws IOException {
        PostResponse postResponse = new PostResponse(response);
        if (postResponse.success()) {
            onResponse(postResponse.json());
        } else {
            onFailure(null, new IOException("Received 2XX but success boolean is False"));
            Log.e("JsonCallback", "received body:" + postResponse.respBody());
        }
    }

    public abstract void onResponse(JSONObject jsonResp);
}
