/*
 * Copyright (C) 2015 Dropbeat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.solidtech.crash.network;

import java.util.Arrays;
import java.util.List;

public class HttpMethod {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String HEAD = "HEAD";
    public static final String OPTIONS = "OPTIONS";
    public static final String CONNECT = "CONNECT";

    public static final List<String> ALL = Arrays.asList(
            GET, POST, PUT, DELETE, HEAD, OPTIONS, CONNECT);

    public static boolean isValid(String method) {
        return HttpMethod.ALL.contains(method.toUpperCase());
    }

    /**
     * Because volley defines HTTP methods as integer (see volley.Request.Method),
     * we should parse it into String.
     * Hard-coding (methodEnum, methodName) pairs is better than using reflection.
     * 1. VolleyLibrary would not change Request.Method (For backward compat)
     * 2. Using reflection in every HTTP request is expensive.
     * @param methodEnum
     * @return
     */
    public static String volleyMethodName(int methodEnum) {
        switch (methodEnum) {
            case -1:
                // DEPRECATED_GET_OR_POST
                return "GET";
            case 0:
                return "GET";
            case 1:
                return "POST";
            case 2:
                return "PUT";
            case 3:
                return "DELETE";
            case 4:
                return "HEAD";
            case 5:
                return "OPTIONS";
            case 6:
                return "TRACE";
            case 7:
                return "PATCH";
            default:
                return null;
        }
    }
}
