package io.solidtech.crash.environments;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import org.json.JSONException;
import org.json.JSONObject;

import io.solidtech.crash.R;
import io.solidtech.crash.SolidClient;

/**
 * Created by vulpes on 2015. 12. 2..
 */
public class ClientInfo {
    public static ClientInfo create(Context context) {
        return new ClientInfo(context);
    }

    public static ClientInfo create(SolidClient client) {
        return new ClientInfo(client.getApplication());
    }

    private final String solidClientName;
    private final String solidClientVersion;
    private final String appVersionName;
    private final int appVersionCode;
    private final String appPackageName;

    private ClientInfo(Context context) {
        solidClientName = context.getString(R.string.solid_client_name);
        solidClientVersion = context.getString(R.string.solid_client_version);

        PackageInfo info = null;
        try {
            info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        } catch (PackageManager.NameNotFoundException e) {
            // do nothing
        }
        appVersionName = info != null ? info.versionName : "unknown";
        appVersionCode = info != null ? info.versionCode : -1;
        appPackageName = context.getPackageName();
    }

    public String getSolidClientName() {
        return solidClientName;
    }

    public String getSolidClientVersion() {
        return solidClientVersion;
    }

    public String getAppVersionName() {
        return appVersionName;
    }

    public int getAppVersionCode() {
        return appVersionCode;
    }

    public String getAppPackageName() {
        return appPackageName;
    }

    public JSONObject toJSONObject() {
        try {
            return new JSONObject().put("solid_client_name", solidClientName)
                    .put("solid_client_version", solidClientVersion)
                    .put("app_version_name", appVersionName)
                    .put("app_version_code", appVersionCode)
                    .put("app_package_name", appPackageName);
        } catch (JSONException e) {
            return null;
        }
    }
}
