package io.solidtech.crash;

import android.content.Context;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.UUID;

import io.solidtech.crash.exceptions.SolidRuntimeException;
import io.solidtech.crash.utils.DeviceUuid;

/**
 * Created by vulpes on 2015. 12. 1..
 */
public class SolidUserInfo {
    public static SolidUserInfo getAnonymous(Context context) {
        synchronized (SolidUserInfo.class) {
            if (sAnonymousUserInfo != null) {
                return sAnonymousUserInfo;
            }

            UUID deviceUuid = DeviceUuid.getUuid(context);
            String identifier = "anonymous:" + deviceUuid.toString();

            sAnonymousUserInfo = new SolidUserInfo(context, identifier, true);
            return sAnonymousUserInfo;
        }
    }

    private static SolidUserInfo sAnonymousUserInfo;

    final String identifier;
    final boolean isAnonymous;
    final String deviceUuid;
    JSONObject customValues = new JSONObject();

    public SolidUserInfo(Context context, String identifier) {
        this(context, identifier, false);
    }

    public SolidUserInfo(Context context, String identifier, boolean isAnonymous) {
        this.identifier = identifier;
        this.isAnonymous = isAnonymous;
        this.deviceUuid = DeviceUuid.getUuid(context).toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public SolidUserInfo putCustomValue(String key, String value) {
        if (value == null) {
            customValues.remove(key);
            return this;
        }
        try {
            customValues.put(key, value);
        } catch (JSONException e) {
            // not reach
        }
        return this;
    }

    public SolidUserInfo putCustomValue(String key, int value) {
        try {
            customValues.put(key, value);
        } catch (JSONException e) {
            // not reach
        }
        return this;
    }

    public SolidUserInfo putCustomValue(String key, long value) {
        try {
            customValues.put(key, value);
        } catch (JSONException e) {
            // not reach
        }
        return this;
    }

    public SolidUserInfo putCustomValue(String key, float value) {
        try {
            customValues.put(key, value);
        } catch (JSONException e) {
            // not reach
        }
        return this;
    }

    public SolidUserInfo putCustomValue(String key, double value) {
        try {
            customValues.put(key, value);
        } catch (JSONException e) {
            // not reach
        }
        return this;
    }

    public SolidUserInfo putCustomValue(String key, boolean value) {
        try {
            customValues.put(key, value);
        } catch (JSONException e) {
            // not reach
        }
        return this;
    }

    public SolidUserInfo putCustomValue(String key, JSONObject value) {
        try {
            customValues.put(key, value);
        } catch (JSONException e) {
            // not reach
        }
        return this;
    }

    public SolidUserInfo putCustomValue(String key, JSONArray value) {
        try {
            customValues.put(key, value);
        } catch (JSONException e) {
            // not reach
        }
        return this;
    }

    @Override
    public String toString() {
        JSONObject obj = toJSONObject();
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public JSONObject toJSONObject() {
        try {
            JSONObject obj = new JSONObject();
            obj.put("identifier", identifier);
            obj.put("is_anonymous", isAnonymous);
            obj.put("user_data", customValues);
            obj.put("device_uuid", deviceUuid);
            return obj;
        } catch (JSONException e) {
            return null;
        }
    }

}
