/*
 * Copyright (C) 2015 Dropbeat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.solidtech.crash.network;

import android.util.Log;

import com.squareup.okhttp.Response;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;

import io.solidtech.crash.SolidClient;

/**
 * Extending `okhttp.Response` is a way better than wrapping it.
 * But `okhttp.Response` is a final class.
 */
public class PostResponse {
    private Response mImpl;
    private String mRespBody;

    public PostResponse(Response response) {
        this.mImpl = response;
        try {
            this.mRespBody = response.body().string();
        } catch (IOException e) {
            // body().string() is called twice. socket is already closed.
            // If we code properly, this should be unreachable.
        }
    }

    public boolean success() {
        if (!mImpl.isSuccessful()) {
            return false;
        }

        JSONObject resp = json();
        if (resp == null) {
            return false;
        }
        return resp.optBoolean("success");
    }

    public JSONObject json() {
        if (mRespBody == null) {
            return null;
        }
        try {
            return new JSONObject(mRespBody);
        } catch (JSONException e) {
            Log.e("PostResponse", "Failed to parse response to json: " + mRespBody);
            return null;
        }
    }

    public String respBody() {
        return mRespBody;
    }
}
