package io.solidtech.crash.api.common;

import android.text.TextUtils;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

import io.solidtech.crash.SolidConstants;
import io.solidtech.crash.network.BasicRequests;
import io.solidtech.crash.network.HttpClient;

/**
 * Created by vulpes on 15. 12. 25..
 */
public class Requests {

    public static Call buildSingleCrashCall(String apiKey, JSONObject crash)
            throws JSONException {

        JSONObject obj = new JSONObject();
        obj.put("app_key", apiKey);
        Iterator<String> iter = crash.keys();
        while (iter.hasNext()) {
            String key = iter.next();
            obj.put(key, crash.get(key));
        }

        RequestBody body = RequestBody.create(BasicRequests.JSON, obj.toString());
        Request request = new Request.Builder().url(Defaults.getUrl(Resources.CRASH)).post(body).build();

        return HttpClient.getInstance().newCall(request);
    }

    public static Call buildBulkCrashCall(String apiKey, JSONArray crashes)
            throws JSONException {

        JSONObject obj = new JSONObject();
        obj.put("app_key", apiKey);
        obj.put("crashes", crashes);

        RequestBody body = RequestBody.create(BasicRequests.JSON, obj.toString());
        Request request = new Request.Builder().url(Defaults.getUrl(Resources.CRASH_BULK)).post(body).build();

        return HttpClient.getInstance().newCall(request);
    }


    public static Call buildUploadVideoCall(String apiKey,
                                            String identifier,
                                            Date createdAt,
                                            File videoFile,
                                            String crashId) {


        SimpleDateFormat format = new SimpleDateFormat(SolidConstants.TIME_FORMAT);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        String createdAtStr = format.format(createdAt);

        MultipartBuilder builder = new MultipartBuilder();
        builder.type(MultipartBuilder.FORM)
               .addPart(Headers.of("Content-Disposition", "form-data; name=\"app_key\""),
                       RequestBody.create(MediaType.parse("text/plain"),
                               apiKey))
               .addPart(Headers.of("Content-Disposition", "form-data; name=\"ext\""),
                       RequestBody.create(MediaType.parse("text/plain"),
                               "gif"))
               .addPart(Headers.of("Content-Disposition", "form-data; name=\"content\"; filename=\"content\""),
                       RequestBody.create(MediaType.parse("image/gif"),
                               videoFile))
               .addPart(Headers.of("Content-Disposition", "form-data; name=\"user_uid\""),
                       RequestBody.create(MediaType.parse("text/plain"),
                               identifier))
               .addPart(Headers.of("Content-Disposition", "form-data; name=\"created_at\""),
                       RequestBody.create(MediaType.parse("text/plain"), createdAtStr));

        if (!TextUtils.isEmpty(crashId)) {
            builder.addPart(Headers.of("Content-Disposition", "form-data; name=\"crash_id\""),
                    RequestBody.create(MediaType.parse("text/plain"), crashId));
        }

        RequestBody requestBody = builder.build();
        Request request = new Request.Builder().url(Defaults.getUrl(Resources.VIDEO_UPLOAD)).post(requestBody).build();

        Call call = HttpClient.getFileUploadClient().newCall(request);
        return call;
    }

    public static Call buildHttpPacketCall(String appKey, JSONArray packetJson) throws JSONException {

        // Generate Json params.
        JSONObject params = new JSONObject();
        params.put("app_key", appKey);
        params.put("packets", packetJson);

        RequestBody body = RequestBody.create(BasicRequests.JSON, params.toString());
        Request request = new Request.Builder().url(Defaults.getUrl(Resources.HTTP_PACKETS)).post(body).build();
        return HttpClient.getInstance().newCall(request);
    }
}
