package io.solidtech.crash;

import android.os.Environment;
import android.text.TextUtils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Solid client generated thread
 * It stands for excluding solid threads when report stacktrace
 */
public class SolidThread extends Thread implements Thread.UncaughtExceptionHandler {
    private static final AtomicInteger sCount = new AtomicInteger(1);

    private static String generateName() {
        return "Solid thread #" + sCount.getAndIncrement();
    }

    public SolidThread() {
        this(generateName());
    }

    public SolidThread(String name) {
        this(null, null, name);
    }

    public SolidThread(Runnable target) {
        this(target, generateName());
    }

    public SolidThread(Runnable target, String name) {
        this(null, target, name);
    }

    public SolidThread(ThreadGroup group, Runnable target) {
        this(group, target, generateName());
    }

    public SolidThread(ThreadGroup group) {
        this(group, generateName());
    }

    public SolidThread(ThreadGroup group, String name) {
        super(group, null, name);
    }

    public SolidThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, TextUtils.isEmpty(name) ? generateName() : name);
        if (SolidConstants.MUTE_SOLID_ERROR) {
            setUncaughtExceptionHandler(this);
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        ex.printStackTrace();
        try {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            File file = new File(Environment.getExternalStoragePublicDirectory(null).getAbsolutePath(),
                    "crashexceptionlog.txt");
            FileOutputStream fos = new FileOutputStream(file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fos));
            writer.write(exceptionAsString);
            writer.flush();
            writer.close();
            fos.close();
        } catch (IOException e) {

        }
        android.os.Process.killProcess(android.os.Process.myPid());
        System.exit(10);
    }

    @Override
    public void run() {
        super.run();
        android.os.Process.setThreadPriority(android.os.Process.THREAD_PRIORITY_BACKGROUND);
    }
}
