package io.solidtech.crash.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;

import java.util.List;

import io.solidtech.crash.R;
import io.solidtech.crash.utils.ViewUtils;

/**
 * Created by vulpes on 2015. 11. 30..
 */
public class CrashButton extends Button implements View.OnClickListener {

    public CrashButton(Context context) {
        super(context);
    }

    public CrashButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        initialize(context);
    }

    public CrashButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initialize(context);
    }

    private void initialize(Context context) {
        setText(context.getString(R.string.solid_btn_crash));
        setBackgroundResource(R.drawable.btn);
        setOnClickListener(this);
        int paddingTop = getPaddingTop();
        int paddingBottom = getPaddingBottom();
        int paddingLeft;
        int paddingRight;
        paddingLeft = paddingRight = ViewUtils.dpToPx(context, 20);
        setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    @Override
    public void onClick(View v) {
        List<String> a = null;
        a.get(0);
    }
}
