//package io.solidtech.crash.video;
//
//import android.graphics.Bitmap;
//
//import org.jcodec.codecs.h264.H264Encoder;
//import org.jcodec.codecs.h264.H264Utils;
//import org.jcodec.common.NIOUtils;
//import org.jcodec.common.SeekableByteChannel;
//import org.jcodec.common.model.ColorSpace;
//import org.jcodec.common.model.Picture;
//import org.jcodec.containers.mp4.Brand;
//import org.jcodec.containers.mp4.MP4Packet;
//import org.jcodec.containers.mp4.TrackType;
//import org.jcodec.containers.mp4.muxer.FramesMP4MuxerTrack;
//import org.jcodec.containers.mp4.muxer.MP4Muxer;
//import org.jcodec.scale.BitmapUtil;
//import org.jcodec.scale.RgbToYuv420j;
//
//import java.io.File;
//import java.io.IOException;
//import java.nio.ByteBuffer;
//import java.util.ArrayList;
//import java.util.List;
//
//import io.solidtech.crash.exceptions.SolidRuntimeException;
//
///**
// * Created by vulpes on 16. 1. 16..
// */
//public class MP4Encoder {
//
//    private final File mDestFile;
//    private final int mTimescale;
//    private final RgbToYuv420j mTransform;
//    private final H264Encoder mEncoder;
//    private final List<ByteBuffer> mSpsList = new ArrayList<>();
//    private final List<ByteBuffer> mPpsList = new ArrayList<>();
//    private final int mFps;
//    private ByteBuffer mBuffer;
//    private SeekableByteChannel mSink;
//    private MP4Muxer mMuxer;
//    private FramesMP4MuxerTrack mOutTrack;
//    private int mFrameCount;
//
//    public MP4Encoder(int timescale, int fps, File destFile) throws IOException {
//        mFrameCount = 0;
//        mDestFile = destFile;
//        mTimescale = timescale;
//        mTransform = new RgbToYuv420j();
//        mEncoder = new H264Encoder();
//        mFps = fps;
//        mSink = NIOUtils.writableFileChannel(mDestFile);
//        mMuxer = new MP4Muxer(mSink, Brand.MP4);
//        mOutTrack = mMuxer.addTrack(TrackType.VIDEO, mTimescale);
//
//        if (mTimescale % mFps > 0) {
//            throw new SolidRuntimeException("Timescale should be scale of fps");
//        }
//    }
//
//    public synchronized void addFrame(Bitmap bitmap) throws IOException {
//        if (mBuffer == null) {
//            mBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 6);
//        }
//
//        Picture picture = BitmapUtil.fromBitmap(bitmap);
//        Picture yuv = Picture.create(picture.getWidth(), picture.getHeight(), ColorSpace.YUV420J);
//
//        // Perform conversion
//        mTransform.transform(picture, yuv);
//
//        mBuffer.clear();
//        ByteBuffer result = mEncoder.encodeFrame(yuv, mBuffer);
//        mSpsList.clear();
//        mPpsList.clear();
//        H264Utils.wipePS(result, mSpsList, mPpsList);
//        H264Utils.encodeMOVPacket(result);
//
//        int ptr = mTimescale / mFps;
//        mOutTrack.addFrame(new MP4Packet(
//                result,
//                ptr * mFrameCount,
//                mTimescale,
//                ptr,
//                mFrameCount,
//                true,
//                null,
//                ptr * mFrameCount,
//                0));
//
//        mFrameCount += 1;
//    }
//
//    public synchronized void finish() throws IOException {
//        if (mOutTrack != null && mMuxer != null) {
//            mOutTrack.addSampleEntry(H264Utils.createMOVSampleEntry(mSpsList, mPpsList, 4));
//            mMuxer.writeHeader();
//        }
//        if (mSink != null) {
//            mSink.close();
//        }
//    }
//}
