package io.solidtech.crash.utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * Created by vulpes on 2015. 12. 1..
 */
public class JsonUtils {
    public static Object wrapNull(Object obj) {
        return obj != null ? obj : JSONObject.NULL;
    }

    public static JSONObject mapToJson(Map<String, String> map) {
        try {
            JSONObject object = new JSONObject();
            for (String key : map.keySet()) {
                object.put(key, map.get(key));
            }
            return object;
        } catch (Exception e) {
            // JsonException, NullPointerException
            return null;
        }
    }

    public static JSONObject diff(JSONObject prev, JSONObject curr) throws JSONException {
        JSONObject diff = new JSONObject();

        Set<String> keys = new HashSet<>();
        Iterator<String> iterator;

        iterator = curr.keys();
        while (iterator.hasNext()) {
            keys.add(iterator.next());
        }

        iterator = prev.keys();
        while (iterator.hasNext()) {
            keys.add(iterator.next());
        }

        for (String key : keys) {
            Object prevVal = prev.opt(key);
            Object currVal = curr.opt(key);

            if (prevVal == null && currVal == null) {
                // not reach
                continue;
            }

            JSONObject diffNode = new JSONObject();
            if (prevVal == null || currVal == null) {

                diffNode.put("curr", currVal == null ? JSONObject.NULL : currVal);
                diffNode.put("prev", prevVal == null ? JSONObject.NULL : prevVal);
                diff.put(key, diffNode);
                continue;
            }

            if (!prevVal.getClass().equals(currVal.getClass())) {

                diffNode.put("curr", currVal);
                diffNode.put("prev", prevVal);
                diff.put(key, diffNode);
                continue;
            }

            if (prevVal instanceof JSONObject) {
                diffNode = diff((JSONObject)currVal, (JSONObject)prevVal);
                if (diffNode == null) {
                    continue;
                }

                diff.put(key, diffNode);
                continue;
            }

            if (equalJsonValue(prevVal, currVal)) {
                continue;
            }

            diffNode.put("curr", currVal);
            diffNode.put("prev", prevVal);
            diff.put(key, diffNode);
        }

        return diff.length() == 0 ? null : diff;
    }

    private static boolean equalJsonValue(Object lhs, Object rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }

        if (lhs == null || rhs == null) {
            return false;
        }

        if (!lhs.getClass().equals(rhs.getClass())) {
            return false;
        }

        if (lhs instanceof JSONObject) {
            JSONObject lhsObj = (JSONObject) lhs;
            JSONObject rhsObj = (JSONObject) rhs;

            Set<String> keys = new HashSet<>();
            Iterator<String> iter;

            iter = lhsObj.keys();
            while (iter.hasNext()) {
                keys.add(iter.next());
            }

            iter = rhsObj.keys();
            while (iter.hasNext()) {
                keys.add(iter.next());
            }


            boolean eq = true;
            for (String key : keys) {
                if (!equalJsonValue(lhsObj.opt(key), rhsObj.opt(key))) {
                    eq = false;
                    break;
                }
            }
            return eq;
        }

        if (lhs instanceof JSONArray) {
            JSONArray lhsArray = (JSONArray)lhs;
            JSONArray rhsArray = (JSONArray)rhs;
            if (lhsArray.length() != rhsArray.length()) {
                return false;
            }
            boolean eq = true;
            for(int i = 0; i < rhsArray.length(); i++) {
                if (!equalJsonValue(rhsArray.opt(i), lhsArray.opt(i))) {
                    eq = false;
                    break;
                }
            }
            return eq;
        }
        return lhs.equals(rhs);
    }
}
