package io.solidtech.crash.utils;

import android.util.Log;

import java.nio.DoubleBuffer;

/**
 * Created by vulpes on 15. 12. 25..
 */
public class DebugUtils {
    public static DebugLogger createDebugLogger(String tag, boolean verbose) {
        return new DebugLogger(tag, verbose);
    }

    public static class DebugLogger {
        private String mTag;
        private boolean mVerbose;
        public DebugLogger(String tag, boolean verbose) {
            mTag = tag;
            mVerbose = verbose;
        }

        public void d(String message) {
            d(mTag, message);
        }

        public void d(String tag, String message) {
            if (mVerbose) {
                Log.d(tag, message);
            }
        }

        public void i(String message) {
            i(mTag, message);
        }

        public void i(String tag, String message) {
            if (mVerbose) {
                Log.i(tag, message);
            }
        }

        public void e(String message) {
            e(mTag, message);
        }

        public void e(String tag, String message) {
            if (mVerbose) {
                Log.e(tag, message);
            }
        }

        public void w(String message) {
            w(mTag, message);
        }

        public void w(String tag, String message) {
            if (mVerbose) {
                Log.w(tag, message);
            }
        }

        public void v(String message) {
            v(mTag, message);
        }

        public void v(String tag, String message) {
            if (mVerbose) {
                Log.v(tag, message);
            }
        }
    }
}
