package io.solidtech.crash.network;

import android.content.Context;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.Map;

/**
 * Created by vulpes on 15. 12. 25..
 */
public class BasicRequests {

    public static final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
    public static final Callback EMPTY_CALLBACK = new Callback() {
        @Override
        public void onFailure(Request request, IOException e) {
        }

        @Override
        public void onResponse(Response response) throws IOException {
        }
    };

    public static Call builPostCall(String url, JSONObject data) throws IOException {
        RequestBody body = RequestBody.create(JSON, data.toString());
        Request request = new Request.Builder().url(url).post(body).build();

        Call call = HttpClient.getInstance().newCall(request);
        return call;
    }

    public static Call buildGetCall(String url, Map<String, String> params) {

        String urlWithParams = url;

        if (params != null && params.size() > 0) {
            urlWithParams += "?";
            for (String key : params.keySet()) {
                if (!urlWithParams.endsWith("?")) {
                    urlWithParams += "&";
                }
                urlWithParams += key + "=" + params.get(key);
            }
        }

        Request request = new Request.Builder().url(urlWithParams).get().build();
        Call call = HttpClient.getInstance().newCall(request);
        return call;
    }
}
