package io.solidtech.crash.environments;

import android.app.Activity;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by vulpes on 2015. 12. 3..
 */
public class ActivityInfo {

    public static final int STATE_CREATED = 0;
    public static final int STATE_STARTED = 1;
    public static final int STATE_RESUMED = 2;
    public static final int STATE_PAUSED = 3;
    public static final int STATE_STOPPED = 4;
    public static final int STATE_DESTROYED = 5;
    public static final int STATE_SAVE_INSTANCE_STATE = 6;

    int index;
    private String simpleName;
    private String name;
    private String state;

    public ActivityInfo(int index, Activity activity) {
        this.index = index;
        simpleName = activity.getClass().getSimpleName();
        name = activity.getClass().getName();
        state = "created";
    }

    public void setState(int state) {
        switch (state) {
            case STATE_CREATED:
                this.state = "created";
                break;
            case STATE_STARTED:
                this.state = "started";
                break;
            case STATE_RESUMED:
                this.state = "resumed";
                break;
            case STATE_PAUSED:
                this.state = "paused";
                break;
            case STATE_STOPPED:
                this.state = "stopped";
                break;
            case STATE_DESTROYED:
                this.state = "destroyed";
                break;
            case STATE_SAVE_INSTANCE_STATE:
                this.state = "save_instance_state";
                break;
        }
    }

    public JSONObject toJSONObject() throws JSONException {
        return new JSONObject()
                .put("index", index)
                .put("simple_name", simpleName)
                .put("name", name)
                .put("state", state);
    }
}
