package io.solidtech.crash.entities.sugar;

import android.text.TextUtils;

import com.orm.SugarRecord;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Collections;
import java.util.List;

import io.solidtech.crash.utils.DebugUtils;

/**
 * Created by vulpes on 16. 2. 3..
 */
public class TrackingInfo extends SugarRecord {

    private static final String TAG = TrackingInfo.class.getSimpleName();
    private static final boolean VERBOSE = true;
    private static final DebugUtils.DebugLogger sLogger = new DebugUtils.DebugLogger(TAG, VERBOSE);

    public static final int TYPE_CRASH = 0;
    public static final int TYPE_VIDEO = 1;
    public static final int TYPE_HTTP_PACKET = 2;

    private int type;
    private String data;

    public static void push(int type, JSONObject data) {
        if (data != null) {
            sLogger.d("pushed data : " + data.toString());
            TrackingInfo info = new TrackingInfo(type, data);
            info.save();
        }
    }

    public static List<TrackingInfo> listAllExceptIds(Long... ids) {
        String[] idsArgs = new String[ids.length];
        for (int i = 0; i < ids.length; i++) {
            idsArgs[i] = String.valueOf(ids[i]);
        }

        String query = "ID not in (" + TextUtils.join(",", Collections.nCopies(ids.length, "?")) + ")";
        return TrackingInfo.find(TrackingInfo.class, query, idsArgs);
    }

    public static int deleteWithIds(Long... ids) {
        String[] idsArgs = new String[ids.length];
        for (int i = 0; i < ids.length; i++) {
            idsArgs[i] = String.valueOf(ids[i]);
        }

        String query = "ID in (" + TextUtils.join(",", Collections.nCopies(ids.length, "?")) + ")";
        return TrackingInfo.deleteAll(TrackingInfo.class, query, idsArgs);
    }

    public static String getReadableType(int typeInt) {
        String type = "undefined";
        switch (typeInt) {
            case TrackingInfo.TYPE_CRASH:
                type = "crash";
                break;
            case TrackingInfo.TYPE_HTTP_PACKET:
                type = "http packet";
                break;
            case TrackingInfo.TYPE_VIDEO:
                type = "video";
                break;
        }
        return type;
    }

    public TrackingInfo() {
    }

    public TrackingInfo(int type, JSONObject data) {
        this.type = type;
        this.data = data.toString();
    }

    public JSONObject getData() {
        try {
            return new JSONObject(data);
        } catch (JSONException e) {
            return null;
        }
    }

    public int getType() {
        return type;
    }
}
