package io.solidtech.crash.api.common;

import android.os.Build;

import java.net.MalformedURLException;
import java.net.URL;

import io.solidtech.crash.BuildConfig;
import io.solidtech.crash.SolidConstants;

/**
 * Created by Ilsu on 2015. 12. 25..
 */
public class Defaults {
    // This prevents instantiation
    private Defaults() {}

    public static final String API_PROTOCOL = "http";
    public static final String API_HOST = SolidConstants.DEBUG ? "www.carbonpad.io" : "core.carbonpad.io";
    public static final int API_PORT = SolidConstants.DEBUG ? -1 : -1;
    public static final String API_VERSION = "v1";

    public static String getUrl(String resource) {
        String subPath = "/api/" + API_VERSION + "/" + resource + "/";
        try {
            URL url = new URL(
                    Defaults.API_PROTOCOL, Defaults.API_HOST,
                    Defaults.API_PORT, subPath
            );
            return url.toString();
        } catch (MalformedURLException e) {
            e.printStackTrace();
            // Unreachable
            return null;
        }
    }

    public static final int DEFAULT_NETWORK_READ_TIMEOUT = 30000;
    public static final int DEFAULT_NETWORK_WRITE_TIMEOUT = 30000;
    public static final int DEFAULT_NETWORK_CONN_TIMEOUT = 10000;
    public static final int FILE_UPLOAD_NETWORK_READ_TIMEOUT = 10 * 60 * 1000;
    public static final int FILE_UPLOAD_NETWORK_WRITE_TIMEOUT = 60 * 1000;
}
