package io.solidtech.crash.actionlog;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

import io.solidtech.crash.SolidConstants;

/**
 * Created by vulpes on 15. 12. 18..
 */
public class ActionLog {
    public enum Type {
        ENVIRONMENT_DIFF,
        USER_ACTION,
        ACTIVITY_DIFF,
        APP_DIFF,
        NETWORK_DIFF
    }

    private final Type mType;
    private Date mWhen;
    private JSONObject mData;

    public ActionLog(Type type, JSONObject data) {
        this(type, null, data);
    }

    public ActionLog(Type type, Date when, JSONObject data) {
        mType = type;
        mWhen = when;
        mData = data;
    }

    public Date getTime() {
        return mWhen;
    }

    public void setTime(Date time) {
        mWhen = time;
    }

    public Type getType() {
        return mType;
    }

    public JSONObject toJSONObject() {
        try {
            JSONObject data = new JSONObject();
            data.put("type", mType.name().toLowerCase());
            data.put("data", mData);

            if (mWhen != null) {
                SimpleDateFormat format = new SimpleDateFormat(SolidConstants.TIME_FORMAT);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                String when = format.format(mWhen);
                data.put("created_at", when);
            }

            return data;
        } catch (JSONException e) {
            return null;
        }
    }
}
