/*
 * Decompiled with CFR 0.152.
 */
package io.socket.socketio.server;

import io.socket.parser.Packet;
import io.socket.socketio.server.SocketIoAdapter;
import io.socket.socketio.server.SocketIoNamespace;
import io.socket.socketio.server.SocketIoSocket;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SocketIoMemoryAdapter
extends SocketIoAdapter {
    private static final String[] EMPTY_SOCKET_EXCLUSION = new String[0];

    private SocketIoMemoryAdapter(SocketIoNamespace namespace) {
        super(namespace);
    }

    public synchronized void broadcast(Packet packet, String[] rooms, String[] socketsExcluded) throws IllegalArgumentException {
        if (packet == null) {
            throw new IllegalArgumentException("packet must not be null.");
        }
        socketsExcluded = socketsExcluded != null ? socketsExcluded : EMPTY_SOCKET_EXCLUSION;
        HashSet socketsExcludedSet = new HashSet();
        Collections.addAll(socketsExcludedSet, socketsExcluded);
        Map<String, SocketIoSocket> connectedSockets = this.mNamespace.getConnectedSockets();
        if (rooms != null) {
            HashSet<String> sentSocketIds = new HashSet<String>();
            for (String room : rooms) {
                if (!this.mRoomSockets.containsKey(room)) continue;
                Set sockets = (Set)this.mRoomSockets.get(room);
                for (SocketIoSocket socket : sockets) {
                    if (socketsExcludedSet.contains(socket.getId()) || sentSocketIds.contains(socket.getId()) || !connectedSockets.containsKey(socket.getId())) continue;
                    socket.sendPacket(packet);
                    sentSocketIds.add(socket.getId());
                }
            }
        } else {
            for (String socketId : this.mSocketRooms.keySet()) {
                SocketIoSocket socket;
                if (socketsExcludedSet.contains(socketId) || (socket = connectedSockets.get(socketId)) == null) continue;
                socket.sendPacket(packet);
            }
        }
    }

    @Override
    public synchronized void add(String room, SocketIoSocket socket) throws IllegalArgumentException {
        if (room == null) {
            throw new IllegalArgumentException("room must not be null.");
        }
        if (socket == null) {
            throw new IllegalArgumentException("socket must not be null.");
        }
        if (!this.mSocketRooms.containsKey(socket.getId())) {
            this.mSocketRooms.put(socket.getId(), new HashSet());
        }
        if (!this.mRoomSockets.containsKey(room)) {
            this.mRoomSockets.put(room, new HashSet());
        }
        ((HashSet)this.mSocketRooms.get(socket.getId())).add(room);
        ((Set)this.mRoomSockets.get(room)).add(socket);
    }

    @Override
    public synchronized void remove(String room, SocketIoSocket socket) throws IllegalArgumentException {
        if (room == null) {
            throw new IllegalArgumentException("room must not be null.");
        }
        if (socket == null) {
            throw new IllegalArgumentException("socket must not be null.");
        }
        if (this.mRoomSockets.containsKey(room)) {
            Set roomSockets = (Set)this.mRoomSockets.get(room);
            roomSockets.remove((Object)socket);
            if (roomSockets.size() == 0) {
                this.mRoomSockets.remove(room);
            }
        }
        if (this.mSocketRooms.containsKey(socket.getId())) {
            Set socketRooms = (Set)this.mSocketRooms.get(socket.getId());
            socketRooms.remove(room);
            if (socketRooms.size() == 0) {
                this.mSocketRooms.remove(socket.getId());
            }
        }
    }

    @Override
    public SocketIoSocket[] listClients(String room) throws IllegalArgumentException {
        if (room == null) {
            throw new IllegalArgumentException("room must not be null.");
        }
        if (this.mRoomSockets.containsKey(room)) {
            return ((Set)this.mRoomSockets.get(room)).toArray(new SocketIoSocket[0]);
        }
        return new SocketIoSocket[0];
    }

    @Override
    public String[] listClientRooms(SocketIoSocket socket) throws IllegalArgumentException {
        if (socket == null) {
            throw new IllegalArgumentException("socket must not be null.");
        }
        if (this.mSocketRooms.containsKey(socket.getId())) {
            return ((HashSet)this.mSocketRooms.get(socket.getId())).toArray(new String[0]);
        }
        return new String[0];
    }

    public static final class Factory
    implements SocketIoAdapter.AdapterFactory {
        @Override
        public SocketIoAdapter createAdapter(SocketIoNamespace namespace) {
            return new SocketIoMemoryAdapter(namespace);
        }
    }
}

