/*
 * Decompiled with CFR 0.152.
 */
package io.socket.socketio.server;

import io.socket.client.Url;
import io.socket.engineio.parser.Packet;
import io.socket.engineio.server.EngineIoSocket;
import io.socket.engineio.server.ReadyState;
import io.socket.parser.IOParser;
import io.socket.parser.Parser;
import io.socket.socketio.server.SocketIoNamespace;
import io.socket.socketio.server.SocketIoNamespaceImpl;
import io.socket.socketio.server.SocketIoServer;
import io.socket.socketio.server.SocketIoSocket;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class SocketIoClient {
    private final SocketIoServer mServer;
    private final EngineIoSocket mConnection;
    private final Parser.Encoder mEncoder;
    private final Parser.Decoder mDecoder;
    private final String mId;
    private final Map<String, SocketIoSocket> mSockets = new ConcurrentHashMap<String, SocketIoSocket>();
    private final Map<String, SocketIoSocket> mNamespaceSockets = new ConcurrentHashMap<String, SocketIoSocket>();

    SocketIoClient(SocketIoServer server, EngineIoSocket connection) {
        this.mServer = server;
        this.mConnection = connection;
        this.mEncoder = server.getEncoder();
        this.mDecoder = new IOParser.Decoder();
        this.mId = connection.getId();
        this.setup();
    }

    String getId() {
        return this.mId;
    }

    void sendPacket(io.socket.parser.Packet packet) {
        if (this.mConnection.getReadyState() == ReadyState.OPEN) {
            this.mEncoder.encode(packet, objects -> {
                for (Object item : objects) {
                    Packet engineIoPacket = new Packet("message");
                    engineIoPacket.data = item;
                    this.mConnection.send(engineIoPacket);
                }
            });
        }
    }

    void connect(String namespace) {
        if (this.mServer.hasNamespace(namespace) || this.mServer.checkNamespace(namespace)) {
            this.doConnect(namespace);
        } else {
            io.socket.parser.Packet packet = new io.socket.parser.Packet(4);
            packet.nsp = namespace;
            packet.data = "Invalid namespace";
            this.sendPacket(packet);
        }
    }

    void remove(SocketIoSocket socket) {
        if (this.mSockets.containsValue((Object)socket)) {
            SocketIoNamespace namespace = socket.getNamespace();
            this.mSockets.remove(socket.getId());
            this.mNamespaceSockets.remove(namespace.getName());
        }
    }

    void disconnect() {
        for (SocketIoSocket socket : this.mSockets.values()) {
            socket.disconnect(false);
        }
        this.mSockets.clear();
        this.close();
    }

    EngineIoSocket getConnection() {
        return this.mConnection;
    }

    private void close() {
        if (this.mConnection.getReadyState() == ReadyState.OPEN) {
            this.mConnection.close();
            this.onClose("forced server close");
        }
    }

    private void setup() {
        this.mDecoder.onDecoded(packet -> {
            if (packet.type == 0) {
                try {
                    this.connect(Url.parse((String)packet.nsp).getPath());
                }
                catch (URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                SocketIoSocket socket = this.mNamespaceSockets.get(packet.nsp);
                if (socket != null) {
                    socket.onPacket(packet);
                }
            }
        });
        this.mConnection.on("data", args -> {
            try {
                Object data = args[0];
                if (data instanceof String) {
                    this.mDecoder.add((String)data);
                } else if (data instanceof byte[]) {
                    this.mDecoder.add((byte[])data);
                }
            }
            catch (Exception ex) {
                this.onError(ex.getMessage());
            }
        });
        this.mConnection.on("error", args -> this.onError((String)args[0]));
        this.mConnection.on("close", args -> this.onClose((String)args[0]));
    }

    private void destroy() {
        this.mConnection.off("data");
        this.mConnection.off("error");
        this.mConnection.off("close");
    }

    private void doConnect(String namespace) {
        SocketIoNamespaceImpl nsp = (SocketIoNamespaceImpl)this.mServer.namespace(namespace);
        SocketIoSocket socket = nsp.add(this);
        this.mSockets.put(socket.getId(), socket);
        this.mNamespaceSockets.put(namespace, socket);
    }

    private void onClose(String reason) {
        this.destroy();
        for (SocketIoSocket socket : this.mSockets.values()) {
            socket.onClose(reason);
        }
        this.mSockets.clear();
        this.mDecoder.destroy();
    }

    private void onError(String error) {
        for (SocketIoSocket socket : this.mSockets.values()) {
            socket.onError(error);
        }
        this.mConnection.close();
    }
}

