/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server;

import io.socket.emitter.Emitter;
import io.socket.engineio.parser.Packet;
import io.socket.engineio.server.EngineIoServer;
import io.socket.engineio.server.ReadyState;
import io.socket.engineio.server.Transport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public final class EngineIoSocket
extends Emitter {
    private static final List<Packet<?>> PAYLOAD_NOOP = new ArrayList<Packet<?>>(){
        {
            this.add(new Packet("noop"));
        }
    };
    private final String mSid;
    private final int mProtocol;
    private final EngineIoServer mServer;
    private final LinkedList<Packet<?>> mWriteBuffer = new LinkedList();
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<SocketedListener>> mCallbacks = new ConcurrentHashMap();
    private final Object mLockObject;
    private final ScheduledExecutorService mScheduledTaskHandler;
    private final Runnable mPingTask = this::sendPing;
    private final Runnable mPingTimeoutTask = () -> this.onClose("ping timeout", null);
    private ScheduledFuture<?> mPingFuture = null;
    private ScheduledFuture<?> mPingTimeoutFuture = null;
    private final AtomicBoolean mUpgrading = new AtomicBoolean(false);
    private Runnable mCleanupFunction = null;
    private ReadyState mReadyState;
    private Transport mTransport;
    private Map<String, String> mInitialQuery;
    private Map<String, List<String>> mInitialHeaders;

    EngineIoSocket(Object lockObject, String sid, int protocol, EngineIoServer server, ScheduledExecutorService scheduledTaskHandler) {
        this.mLockObject = lockObject;
        this.mSid = sid;
        this.mProtocol = protocol;
        this.mServer = server;
        this.mScheduledTaskHandler = scheduledTaskHandler;
        this.mReadyState = ReadyState.OPENING;
    }

    public String getId() {
        return this.mSid;
    }

    public ReadyState getReadyState() {
        return this.mReadyState;
    }

    public Map<String, String> getInitialQuery() {
        return this.mInitialQuery;
    }

    public Map<String, List<String>> getInitialHeaders() {
        return this.mInitialHeaders;
    }

    public void send(Packet<?> packet) {
        this.sendPacket(packet);
    }

    public void close() {
        if (this.mReadyState == ReadyState.OPEN) {
            this.mReadyState = ReadyState.CLOSING;
            if (this.mWriteBuffer.size() > 0) {
                this.mTransport.on("drain", (Object[] args) -> this.closeTransport());
            } else {
                this.closeTransport();
            }
        }
    }

    public EngineIoSocket on(String event, SocketedListener fn) {
        this.mCallbacks.computeIfAbsent(event, s -> new ConcurrentLinkedQueue());
        ConcurrentLinkedQueue<SocketedListener> callbacks = this.mCallbacks.get(event);
        callbacks.add(fn);
        return this;
    }

    public EngineIoSocket off(String event, SocketedListener fn) {
        ConcurrentLinkedQueue<SocketedListener> callbacks = this.mCallbacks.get(event);
        if (callbacks != null) {
            Iterator<SocketedListener> it = callbacks.iterator();
            while (it.hasNext()) {
                SocketedListener internal = it.next();
                if (!fn.equals(internal)) continue;
                it.remove();
                break;
            }
        }
        return this;
    }

    @Override
    public EngineIoSocket off(String event) {
        this.mCallbacks.remove(event);
        return (EngineIoSocket)super.off(event);
    }

    @Override
    public Emitter emit(String event, Object ... args) {
        ConcurrentLinkedQueue<SocketedListener> callbacks = this.mCallbacks.get(event);
        if (callbacks != null) {
            for (SocketedListener fn : callbacks) {
                try {
                    fn.call(this, args);
                }
                catch (Exception exception) {}
            }
        }
        return super.emit(event, args);
    }

    void init(Transport transport) {
        this.setTransport(transport);
        this.mInitialQuery = transport.getInitialQuery();
        this.mInitialHeaders = transport.getInitialHeaders();
        this.onOpen();
    }

    void updateInitialHeadersFromActiveTransport() {
        this.mInitialQuery = this.mTransport.getInitialQuery();
        this.mInitialHeaders = this.mTransport.getInitialHeaders();
    }

    void onRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.mTransport.onRequest(request, response);
        if (this.mUpgrading.get() && this.mTransport.isWritable() && this.mWriteBuffer.isEmpty()) {
            this.mTransport.send(PAYLOAD_NOOP);
        }
    }

    boolean canUpgrade(String transport) {
        return !this.mUpgrading.get() && this.mTransport.getName().equals("polling") && transport.equals("websocket");
    }

    void upgrade(Transport transport) {
        this.mUpgrading.set(true);
        Runnable cleanup = () -> {
            this.mUpgrading.set(false);
            transport.off("packet");
            transport.off("close");
            transport.off("error");
        };
        Emitter.Listener onError = args -> {
            cleanup.run();
            transport.close();
        };
        transport.on("packet", (Object[] args) -> {
            Packet packet = (Packet)args[0];
            if (packet.type.equals("ping") && packet.data != null && packet.data.equals("probe")) {
                final Packet replyPacket = new Packet("pong");
                replyPacket.data = "probe";
                transport.send(new ArrayList<Packet<?>>(){
                    {
                        this.add(replyPacket);
                    }
                });
                if (this.mTransport.isWritable()) {
                    this.mTransport.send(PAYLOAD_NOOP);
                }
                this.emit("upgrading", transport);
            } else if (packet.type.equals("upgrade") && this.mReadyState != ReadyState.CLOSED && this.mReadyState != ReadyState.CLOSING) {
                cleanup.run();
                this.clearTransport();
                this.setTransport(transport);
                this.emit("upgrade", transport);
                this.flush();
                this.schedulePing();
            } else {
                cleanup.run();
                transport.close();
            }
        });
        transport.once("close", args -> onError.call("transport closed"));
        transport.once("error", onError);
        this.once("close", args -> onError.call("socket closed"));
    }

    String getCurrentTransportName() {
        return this.mTransport.getName();
    }

    private void setTransport(Transport transport) {
        this.mTransport = transport;
        transport.once("error", args -> this.onError());
        transport.once("close", args -> {
            String description = args.length > 0 ? (String)args[0] : null;
            this.onClose("transport close", description);
        });
        transport.on("packet", (Object[] args) -> this.onPacket((Packet)args[0]));
        transport.on("drain", (Object[] args) -> this.flush());
        this.mCleanupFunction = () -> {
            transport.off("error");
            transport.off("close");
            transport.off("packet");
            transport.off("drain");
        };
    }

    private void closeTransport() {
        this.mTransport.close();
    }

    private void clearTransport() {
        if (this.mCleanupFunction != null) {
            this.mCleanupFunction.run();
        }
        this.mTransport.close();
    }

    private void onOpen() {
        this.mReadyState = ReadyState.OPEN;
        JSONArray upgrades = new JSONArray();
        upgrades.put((Object)"websocket");
        JSONObject handshakePacket = new JSONObject();
        handshakePacket.put("sid", (Object)this.mSid);
        handshakePacket.put("upgrades", (Object)upgrades);
        handshakePacket.put("pingInterval", this.mServer.getOptions().getPingInterval());
        handshakePacket.put("pingTimeout", this.mServer.getOptions().getPingTimeout());
        Packet openPacket = new Packet("open");
        openPacket.data = handshakePacket.toString();
        this.sendPacket(openPacket);
        if (this.mServer.getOptions().getInitialPacket() != null) {
            this.sendPacket(this.mServer.getOptions().getInitialPacket());
        }
        this.emit("open", new Object[0]);
        switch (this.mProtocol) {
            case 3: {
                this.resetPingTimeout(this.mServer.getOptions().getPingTimeout() + this.mServer.getOptions().getPingInterval());
                break;
            }
            case 4: {
                this.schedulePing();
                break;
            }
            default: {
                throw new RuntimeException("Invalid protocol version");
            }
        }
    }

    private void onClose(String reason, String description) {
        if (this.mReadyState != ReadyState.CLOSED) {
            this.mReadyState = ReadyState.CLOSED;
            if (this.mPingFuture != null) {
                this.mPingFuture.cancel(false);
            }
            this.clearTransport();
            this.emit("close", reason, description);
        }
    }

    private void onError() {
        this.onClose("transport error", null);
    }

    private void onPacket(Packet<?> packet) {
        if (this.mReadyState == ReadyState.OPEN) {
            this.emit("packet", packet);
            this.resetPingTimeout(this.mServer.getOptions().getPingTimeout() + this.mServer.getOptions().getPingInterval());
            switch (packet.type) {
                case "ping": {
                    if (this.mProtocol != 3) {
                        this.onError();
                        break;
                    }
                    this.sendPacket(new Packet("pong"));
                    this.emit("heartbeat", new Object[0]);
                    break;
                }
                case "pong": {
                    this.schedulePing();
                    this.emit("heartbeat", new Object[0]);
                    break;
                }
                case "error": {
                    this.onClose("parse error", null);
                    break;
                }
                case "message": {
                    this.emit("data", packet.data);
                    this.emit("message", packet.data);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacket(Packet<?> packet) {
        if (this.mReadyState != ReadyState.CLOSING && this.mReadyState != ReadyState.CLOSED) {
            Object object = this.mLockObject;
            synchronized (object) {
                this.mWriteBuffer.add(packet);
            }
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        if (this.mReadyState != ReadyState.CLOSED && this.mTransport.isWritable() && this.mWriteBuffer.size() > 0) {
            Object object = this.mLockObject;
            synchronized (object) {
                this.emit("flush", Collections.unmodifiableCollection(this.mWriteBuffer));
                this.mTransport.send(this.mWriteBuffer);
                this.mWriteBuffer.clear();
            }
            this.emit("drain", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPing() {
        Object object = this.mLockObject;
        synchronized (object) {
            this.sendPacket(new Packet("ping"));
            this.resetPingTimeout(this.mServer.getOptions().getPingTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePing() {
        Object object = this.mLockObject;
        synchronized (object) {
            if (this.mPingFuture != null) {
                this.mPingFuture.cancel(false);
            }
            this.mPingFuture = this.mScheduledTaskHandler.schedule(this.mPingTask, this.mServer.getOptions().getPingInterval(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPingTimeout(long timeout) {
        Object object = this.mLockObject;
        synchronized (object) {
            if (this.mPingTimeoutFuture != null) {
                this.mPingTimeoutFuture.cancel(false);
            }
            this.mPingTimeoutFuture = this.mScheduledTaskHandler.schedule(this.mPingTimeoutTask, timeout, TimeUnit.MILLISECONDS);
        }
    }

    public static interface SocketedListener {
        public void call(EngineIoSocket var1, Object ... var2);
    }
}

