/*
 * Decompiled with CFR 0.152.
 */
package io.socket.emitter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public class Emitter {
    private final ConcurrentMap<String, ConcurrentLinkedQueue<Listener>> mCallbacks = new ConcurrentHashMap<String, ConcurrentLinkedQueue<Listener>>();

    public Emitter on(String event, Listener fn) {
        this.mCallbacks.computeIfAbsent(event, s -> new ConcurrentLinkedQueue());
        ConcurrentLinkedQueue callbacks = (ConcurrentLinkedQueue)this.mCallbacks.get(event);
        callbacks.add(fn);
        return this;
    }

    public Emitter once(String event, Listener fn) {
        this.on(event, new OnceListener(event, fn));
        return this;
    }

    public Emitter off() {
        this.mCallbacks.clear();
        return this;
    }

    public Emitter off(String event) {
        this.mCallbacks.remove(event);
        return this;
    }

    public Emitter off(String event, Listener fn) {
        ConcurrentLinkedQueue callbacks = (ConcurrentLinkedQueue)this.mCallbacks.get(event);
        if (callbacks != null) {
            Iterator it = callbacks.iterator();
            while (it.hasNext()) {
                Listener internal = (Listener)it.next();
                if (!Emitter.sameAs(fn, internal)) continue;
                it.remove();
                break;
            }
        }
        return this;
    }

    public Emitter emit(String event, Object ... args) {
        ConcurrentLinkedQueue callbacks = (ConcurrentLinkedQueue)this.mCallbacks.get(event);
        if (callbacks != null) {
            for (Listener fn : callbacks) {
                try {
                    fn.call(args);
                }
                catch (Exception exception) {}
            }
        }
        return this;
    }

    public List<Listener> listeners(String event) {
        ConcurrentLinkedQueue callbacks = (ConcurrentLinkedQueue)this.mCallbacks.get(event);
        return callbacks != null ? Collections.unmodifiableList(new ArrayList(callbacks)) : Collections.emptyList();
    }

    public boolean hasListeners(String event) {
        ConcurrentLinkedQueue callbacks = (ConcurrentLinkedQueue)this.mCallbacks.get(event);
        return callbacks != null && !callbacks.isEmpty();
    }

    private static boolean sameAs(Listener fn, Listener internal) {
        if (fn.equals(internal)) {
            return true;
        }
        if (internal instanceof OnceListener) {
            return fn.equals(((OnceListener)internal).fn);
        }
        return false;
    }

    private class OnceListener
    implements Listener {
        public final String event;
        public final Listener fn;

        public OnceListener(String event, Listener fn) {
            this.event = event;
            this.fn = fn;
        }

        @Override
        public void call(Object ... args) {
            Emitter.this.off(this.event, this);
            this.fn.call(args);
        }
    }

    public static interface Listener {
        public void call(Object ... var1);
    }
}

