/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server;

import io.socket.emitter.Emitter;
import io.socket.engineio.parser.Packet;
import io.socket.engineio.parser.Parser;
import io.socket.engineio.server.ReadyState;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class Transport
extends Emitter {
    protected final Parser mParser;
    protected ReadyState mReadyState;

    protected Transport(Parser parser) {
        this.mParser = parser;
        this.mReadyState = ReadyState.OPEN;
    }

    public abstract Map<String, String> getInitialQuery();

    public abstract Map<String, List<String>> getInitialHeaders();

    public abstract void onRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public abstract void send(List<Packet<?>> var1);

    public abstract boolean isWritable();

    public abstract String getName();

    protected abstract void doClose();

    public void close() {
        if (this.mReadyState != ReadyState.CLOSED && this.mReadyState != ReadyState.CLOSING) {
            this.mReadyState = ReadyState.CLOSING;
            this.doClose();
        }
    }

    protected void onError(String reason, String description) {
        if (this.listeners("error").size() > 0) {
            this.emit("error", reason, description);
        }
    }

    protected void onPacket(Packet<?> packet) {
        this.emit("packet", packet);
    }

    protected void onData(Object data) {
        this.onPacket(this.mParser.decodePacket(data));
    }

    protected void onClose() {
        this.mReadyState = ReadyState.CLOSED;
        this.emit("close", new Object[0]);
    }
}

