/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.parser;

import io.socket.engineio.parser.Packet;
import io.socket.engineio.parser.Parser;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ServerParser {
    public static final int PROTOCOL = 4;
    private static final String SEPARATOR = "\u001e";
    private static final Packet<String> ERROR_PACKET = new Packet("error", (Object)"parser error");
    private static final Map<String, Integer> packets = new HashMap<String, Integer>(){
        {
            this.put("open", 0);
            this.put("close", 1);
            this.put("ping", 2);
            this.put("pong", 3);
            this.put("message", 4);
            this.put("upgrade", 5);
            this.put("noop", 6);
        }
    };
    private static final Map<Integer, String> packetsList = new HashMap<Integer, String>();

    private ServerParser() {
    }

    public static void encodePacket(Packet packet, boolean supportsBinary, Parser.EncodeCallback callback) {
        if (packet.data instanceof byte[]) {
            ServerParser.encodeByteArray((Packet<byte[]>)packet, supportsBinary, callback);
        } else {
            String encoded = String.valueOf(packets.get(packet.type));
            if (null != packet.data) {
                encoded = encoded + String.valueOf(packet.data);
            }
            callback.call((Object)encoded);
        }
    }

    public static void encodePayload(List<Packet<?>> packets, Parser.EncodeCallback callback) {
        CharSequence[] encodedPackets = new String[packets.size()];
        int i = 0;
        while (i < encodedPackets.length) {
            Packet<?> packet = packets.get(i);
            int packetIdx = i++;
            ServerParser.encodePacket(packet, false, arg_0 -> ServerParser.lambda$encodePayload$0((String[])encodedPackets, packetIdx, arg_0));
        }
        callback.call((Object)String.join((CharSequence)SEPARATOR, encodedPackets));
    }

    public static Packet decodePacket(Object data) {
        if (data == null) {
            return ERROR_PACKET;
        }
        if (data instanceof String) {
            String stringData = (String)data;
            if (stringData.charAt(0) == 'b') {
                Packet packet = new Packet("message");
                packet.data = Base64.getDecoder().decode(stringData.substring(1));
                return packet;
            }
            Packet packet = new Packet(packetsList.get(Integer.parseInt(String.valueOf(stringData.charAt(0)))));
            packet.data = stringData.substring(1);
            return packet;
        }
        if (data instanceof byte[]) {
            return new Packet("message", (Object)((byte[])data));
        }
        throw new IllegalArgumentException("Invalid type for data: " + data.getClass().getSimpleName());
    }

    public static void decodePayload(Object data, Parser.DecodePayloadCallback callback) {
        assert (callback != null);
        ArrayList<Packet> packets = new ArrayList<Packet>();
        if (data instanceof String) {
            String[] encodedPackets;
            for (String encodedPacket : encodedPackets = ((String)data).split(SEPARATOR)) {
                Packet packet = ServerParser.decodePacket(encodedPacket);
                packets.add(packet);
                if (!packet.type.equals("error")) {
                    continue;
                }
                break;
            }
        } else {
            throw new IllegalArgumentException("data must be a String");
        }
        for (int i = 0; i < packets.size(); ++i) {
            if (callback.call((Packet)packets.get(i), i, packets.size())) continue;
            return;
        }
    }

    private static void encodeByteArray(Packet<byte[]> packet, boolean supportsBinary, Parser.EncodeCallback callback) {
        if (supportsBinary) {
            callback.call(packet.data);
        } else {
            String resultBuilder = "b" + Base64.getEncoder().encodeToString((byte[])packet.data);
            callback.call((Object)resultBuilder);
        }
    }

    private static /* synthetic */ void lambda$encodePayload$0(String[] encodedPackets, int packetIdx, Object data) {
        encodedPackets[packetIdx] = (String)data;
    }

    static {
        for (Map.Entry<String, Integer> entry : packets.entrySet()) {
            packetsList.put(entry.getValue(), entry.getKey());
        }
    }
}

