/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server;

import io.socket.emitter.Emitter;
import io.socket.engineio.server.EngineIoServerOptions;
import io.socket.engineio.server.EngineIoSocket;
import io.socket.engineio.server.EngineIoSocketTimeoutHandler;
import io.socket.engineio.server.EngineIoWebSocket;
import io.socket.engineio.server.ServerErrors;
import io.socket.engineio.server.Transport;
import io.socket.engineio.server.transport.Polling;
import io.socket.engineio.server.transport.WebSocket;
import io.socket.parseqs.ParseQS;
import io.socket.yeast.ServerYeast;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public final class EngineIoServer
extends Emitter {
    private final Map<String, EngineIoSocket> mClients = new ConcurrentHashMap<String, EngineIoSocket>();
    private final EngineIoSocketTimeoutHandler mPingTimeoutHandler;
    private final EngineIoServerOptions mOptions;

    public EngineIoServer() {
        this(EngineIoServerOptions.DEFAULT);
    }

    public EngineIoServer(EngineIoServerOptions options) {
        this.mOptions = options;
        this.mOptions.lock();
        this.mPingTimeoutHandler = new EngineIoSocketTimeoutHandler(this.mOptions.getMaxTimeoutThreadPoolSize());
    }

    public EngineIoServerOptions getOptions() {
        return this.mOptions;
    }

    @Deprecated
    public long getPingTimeout() {
        return this.mOptions.getPingTimeout();
    }

    @Deprecated
    public long getPingInterval() {
        return this.mOptions.getPingInterval();
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map query = ParseQS.decode((String)request.getQueryString());
        request.setAttribute("query", (Object)query);
        if (!this.mOptions.isCorsHandlingDisabled()) {
            boolean sendCors;
            String origin = request.getHeader("Origin");
            boolean bl = sendCors = origin != null && (this.mOptions.getAllowedCorsOrigins() == EngineIoServerOptions.ALLOWED_CORS_ORIGIN_ALL || Arrays.binarySearch(this.mOptions.getAllowedCorsOrigins(), origin) >= 0);
            if (sendCors) {
                response.addHeader("Access-Control-Allow-Origin", origin);
                response.addHeader("Access-Control-Allow-Credentials", "true");
                response.addHeader("Access-Control-Allow-Methods", "GET,HEAD,PUT,PATCH,POST,DELETE");
                response.addHeader("Access-Control-Allow-Headers", "origin, content-type, accept");
            }
        }
        if (!query.containsKey("transport") || !((String)query.get("transport")).equals("polling")) {
            this.sendErrorMessage(response, ServerErrors.UNKNOWN_TRANSPORT);
            return;
        }
        String sid = (String)query.get("sid");
        if (sid != null) {
            if (!this.mClients.containsKey(query.get("sid"))) {
                this.sendErrorMessage(response, ServerErrors.UNKNOWN_SID);
            } else if (!query.containsKey("transport") || !((String)query.get("transport")).equals(this.mClients.get(sid).getCurrentTransportName())) {
                this.sendErrorMessage(response, ServerErrors.BAD_REQUEST);
            } else {
                this.mClients.get(sid).onRequest(request, response);
            }
        } else if (!request.getMethod().toUpperCase().equals("GET")) {
            this.sendErrorMessage(response, ServerErrors.BAD_HANDSHAKE_METHOD);
        } else {
            this.handshakePolling(request, response);
        }
    }

    public void handleWebSocket(EngineIoWebSocket webSocket) {
        Map<String, String> query = webSocket.getQuery();
        String sid = query.get("sid");
        if (sid != null) {
            EngineIoSocket socket = this.mClients.get(sid);
            if (socket == null) {
                webSocket.close();
            } else if (!socket.canUpgrade("websocket")) {
                webSocket.close();
            } else {
                WebSocket transport = new WebSocket(webSocket);
                socket.upgrade(transport);
            }
        } else {
            this.handshakeWebSocket(webSocket);
        }
    }

    private void sendErrorMessage(HttpServletResponse response, ServerErrors code) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (code != null) {
            response.setStatus(400);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", code.getCode());
            jsonObject.put("message", (Object)code.getMessage());
            response.getWriter().write(jsonObject.toString());
        } else {
            response.setStatus(403);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", ServerErrors.FORBIDDEN.getCode());
            jsonObject.put("message", (Object)ServerErrors.FORBIDDEN.getMessage());
            response.getWriter().write(jsonObject.toString());
        }
    }

    private void handshakePolling(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String sid = ServerYeast.yeast();
        Polling transport = new Polling();
        EngineIoSocket socket = new EngineIoSocket(sid, this, this.mPingTimeoutHandler);
        socket.init(transport, request);
        ((Transport)transport).onRequest(request, response);
        this.mClients.put(sid, socket);
        socket.once("close", args -> this.mClients.remove(sid));
        this.emit("connection", new Object[]{socket});
    }

    private void handshakeWebSocket(EngineIoWebSocket webSocket) {
        String sid = ServerYeast.yeast();
        WebSocket transport = new WebSocket(webSocket);
        EngineIoSocket socket = new EngineIoSocket(sid, this, this.mPingTimeoutHandler);
        socket.init(transport, null);
        this.mClients.put(sid, socket);
        socket.once("close", args -> this.mClients.remove(sid));
        this.emit("connection", new Object[]{socket});
    }
}

