/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server.transport;

import io.socket.emitter.Emitter;
import io.socket.engineio.parser.Packet;
import io.socket.engineio.parser.Parser;
import io.socket.engineio.parser.ServerParser;
import io.socket.engineio.server.EngineIoWebSocket;
import io.socket.engineio.server.Transport;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WebSocket
extends Transport {
    public static final String NAME = "websocket";
    private final EngineIoWebSocket mConnection;

    public WebSocket(EngineIoWebSocket webSocket) {
        this.mConnection = webSocket;
        this.mConnection.on("message", new Emitter.Listener(){

            public void call(Object ... args) {
                WebSocket.this.onData(args[0]);
            }
        });
        this.mConnection.on("close", new Emitter.Listener(){

            public void call(Object ... args) {
                WebSocket.this.onClose();
            }
        });
        this.mConnection.on("error", new Emitter.Listener(){

            public void call(Object ... args) {
                WebSocket.this.onError((String)args[0], (String)args[1]);
            }
        });
    }

    @Override
    public void onRequest(HttpServletRequest request, HttpServletResponse response) {
    }

    @Override
    public void send(List<Packet> packets) {
        Parser.EncodeCallback encodeCallback = new Parser.EncodeCallback(){

            public void call(Object data) {
                try {
                    if (data instanceof String) {
                        WebSocket.this.mConnection.write((String)data);
                    } else if (data instanceof byte[]) {
                        WebSocket.this.mConnection.write((byte[])data);
                    }
                }
                catch (IOException ex) {
                    WebSocket.this.onError("write error", ex.getMessage());
                }
            }
        };
        for (Packet packet : packets) {
            ServerParser.encodePacket(packet, true, encodeCallback);
        }
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void doClose() {
        this.mConnection.close();
    }
}

