/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server.transport;

import io.socket.engineio.parser.Packet;
import io.socket.engineio.parser.Parser;
import io.socket.engineio.parser.ServerParser;
import io.socket.engineio.server.Transport;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class Polling
extends Transport {
    public static final String NAME = "polling";
    private static final List<Packet> PACKET_CLOSE = Collections.unmodifiableList(new ArrayList<Packet>(){
        {
            this.add(new Packet("close"));
        }
    });
    private static final List<Packet> PACKET_NOOP = Collections.unmodifiableList(new ArrayList<Packet>(){
        {
            this.add(new Packet("noop"));
        }
    });
    private HttpServletRequest mRequest;
    private HttpServletResponse mResponse;
    private boolean mWritable = false;
    private boolean mShouldClose = false;

    @Override
    public synchronized void onRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.mRequest = request;
        this.mResponse = response;
        switch (request.getMethod().toLowerCase()) {
            case "get": {
                this.onPollRequest(request, response);
                break;
            }
            case "post": {
                this.onDataRequest(request, response);
                break;
            }
            default: {
                response.setStatus(500);
                response.getWriter().write("");
            }
        }
        this.mRequest = null;
        this.mResponse = null;
    }

    @Override
    public synchronized void send(List<Packet> packets) {
        boolean supportsBinary;
        this.mWritable = false;
        if (this.mShouldClose) {
            packets.add(new Packet("close"));
        }
        boolean bl = supportsBinary = !((Map)this.mRequest.getAttribute("query")).containsKey("b64");
        if (packets.size() == 0) {
            throw new IllegalArgumentException("No packets to send.");
        }
        ServerParser.encodePayload(packets.toArray(new Packet[0]), supportsBinary, new Parser.EncodeCallback(){

            public void call(Object data) {
                String contentType = data instanceof String ? "text/plain; charset=UTF-8" : "application/octet-stream";
                int contentLength = data instanceof String ? ((String)data).length() : ((byte[])data).length;
                Polling.this.mResponse.setContentType(contentType);
                Polling.this.mResponse.setContentLength(contentLength);
                try (ServletOutputStream outputStream = Polling.this.mResponse.getOutputStream();){
                    byte[] writeBytes = data instanceof String ? ((String)data).getBytes(StandardCharsets.UTF_8) : (byte[])data;
                    outputStream.write(writeBytes);
                }
                catch (IOException ex) {
                    Polling.this.onError("write failure", ex.getMessage());
                }
            }
        });
        if (this.mShouldClose) {
            this.onClose();
        }
    }

    @Override
    public boolean isWritable() {
        return this.mWritable;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected synchronized void doClose() {
        if (this.mWritable) {
            this.send(new ArrayList<Packet>(PACKET_CLOSE));
            this.onClose();
        } else {
            this.mShouldClose = true;
        }
    }

    @Override
    protected void onData(Object data) {
        ServerParser.decodePayload(data, new Parser.DecodePayloadCallback(){

            public boolean call(Packet packet, int index, int total) {
                if (packet.type.equals("close")) {
                    Polling.this.onClose();
                    return false;
                }
                Polling.this.onPacket(packet);
                return true;
            }
        });
    }

    @Override
    protected void onClose() {
        if (this.mWritable) {
            this.send(new ArrayList<Packet>(PACKET_NOOP));
        }
        super.onClose();
    }

    private void onPollRequest(HttpServletRequest request, HttpServletResponse response) {
        this.mWritable = true;
        this.emit("drain", new Object[0]);
        if (this.mWritable) {
            this.send(new ArrayList<Packet>(PACKET_NOOP));
        }
    }

    private void onDataRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isBinary = request.getContentType().equals("application/octet-stream");
        try (ServletInputStream inputStream = request.getInputStream();){
            Object object;
            byte[] mReadBuffer = new byte[request.getContentLength()];
            inputStream.read(mReadBuffer, 0, inputStream.available());
            if (isBinary) {
                object = mReadBuffer;
            } else {
                String string;
                object = string;
                string = new String(mReadBuffer, StandardCharsets.UTF_8);
            }
            this.onData(object);
        }
        response.setContentType("text/html");
        response.getWriter().write("ok");
    }
}

