/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server;

import io.socket.emitter.Emitter;
import io.socket.engineio.parser.Packet;
import io.socket.engineio.parser.ServerParser;
import io.socket.engineio.server.ReadyState;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class Transport
extends Emitter {
    protected ReadyState mReadyState = ReadyState.OPEN;

    protected Transport() {
    }

    public abstract void onRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public abstract void send(List<Packet> var1);

    public abstract boolean isWritable();

    public abstract String getName();

    protected abstract void doClose();

    public void close() {
        if (this.mReadyState != ReadyState.CLOSED && this.mReadyState != ReadyState.CLOSING) {
            this.mReadyState = ReadyState.CLOSING;
            this.doClose();
        }
    }

    protected void onError(String reason, String description) {
        if (this.listeners("error").size() > 0) {
            this.emit("error", new Object[]{reason, description});
        }
    }

    protected void onPacket(Packet packet) {
        this.emit("packet", new Object[]{packet});
    }

    protected void onData(Object data) {
        this.onPacket(ServerParser.decodePacket(data));
    }

    protected void onClose() {
        this.mReadyState = ReadyState.CLOSED;
        this.emit("close", new Object[0]);
    }
}

