/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server;

import io.socket.emitter.Emitter;
import io.socket.engineio.parser.Packet;
import io.socket.engineio.server.EngineIoServer;
import io.socket.engineio.server.ReadyState;
import io.socket.engineio.server.Transport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public final class EngineIoSocket
extends Emitter {
    private final String mSid;
    private final EngineIoServer mServer;
    private final LinkedList<Packet> mWriteBuffer = new LinkedList();
    private final Timer mPingTimer = new Timer();
    private TimerTask mPingTimeout = null;
    private Runnable mCleanupFunction = null;
    private ReadyState mReadyState;
    private Transport mTransport;
    private boolean mUpgrading = false;

    EngineIoSocket(String sid, EngineIoServer server) {
        this.mSid = sid;
        this.mServer = server;
        this.mReadyState = ReadyState.OPENING;
    }

    public void send(Packet packet) {
        this.sendPacket(packet);
    }

    public void close() {
        if (this.mReadyState == ReadyState.OPEN) {
            this.mReadyState = ReadyState.CLOSING;
            if (this.mWriteBuffer.size() > 0) {
                this.mTransport.on("drain", new Emitter.Listener(){

                    public void call(Object ... args) {
                        EngineIoSocket.this.closeTransport();
                    }
                });
            } else {
                this.closeTransport();
            }
        }
    }

    void init(Transport transport, HttpServletRequest initialRequest) {
        this.setTransport(transport);
        this.onOpen();
    }

    void onRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.mTransport.onRequest(request, response);
    }

    boolean canUpgrade(String transport) {
        return !this.mUpgrading && this.mTransport.getName().equals("polling") && transport.equals("websocket");
    }

    void upgrade(final Transport transport) {
        this.mUpgrading = true;
        final Runnable cleanup = new Runnable(){

            @Override
            public void run() {
                EngineIoSocket.this.mUpgrading = false;
                transport.off("packet");
                transport.off("close");
                transport.off("error");
                EngineIoSocket.this.off("close");
            }
        };
        final Emitter.Listener onError = new Emitter.Listener(){

            public void call(Object ... args) {
                cleanup.run();
                transport.close();
            }
        };
        transport.on("packet", new Emitter.Listener(){

            public void call(Object ... args) {
                Packet packet = (Packet)args[0];
                if (packet.type.equals("ping") && packet.data != null && packet.data.equals("probe")) {
                    final Packet replyPacket = new Packet("pong");
                    replyPacket.data = "probe";
                    transport.send((List<Packet>)new ArrayList<Packet>(){
                        {
                            this.add(replyPacket);
                        }
                    });
                    EngineIoSocket.this.emit("upgrading", new Object[]{transport});
                } else if (packet.type.equals("upgrade") && EngineIoSocket.this.mReadyState != ReadyState.CLOSED && EngineIoSocket.this.mReadyState != ReadyState.CLOSING) {
                    cleanup.run();
                    EngineIoSocket.this.clearTransport();
                    EngineIoSocket.this.setTransport(transport);
                    EngineIoSocket.this.emit("upgrade", new Object[]{transport});
                    EngineIoSocket.this.flush();
                    EngineIoSocket.this.resetPingTimeout();
                } else {
                    cleanup.run();
                    transport.close();
                }
            }
        });
        transport.once("close", new Emitter.Listener(){

            public void call(Object ... args) {
                onError.call(new Object[]{"transport closed"});
            }
        });
        transport.once("error", onError);
        this.once("close", new Emitter.Listener(){

            public void call(Object ... args) {
                onError.call(new Object[]{"socket closed"});
            }
        });
    }

    String getCurrentTransportName() {
        return this.mTransport.getName();
    }

    private void setTransport(final Transport transport) {
        this.mTransport = transport;
        transport.once("error", new Emitter.Listener(){

            public void call(Object ... args) {
                EngineIoSocket.this.onError();
            }
        });
        transport.once("close", new Emitter.Listener(){

            public void call(Object ... args) {
                String description = args.length > 0 ? (String)args[0] : null;
                EngineIoSocket.this.onClose("transport close", description);
            }
        });
        transport.on("packet", new Emitter.Listener(){

            public void call(Object ... args) {
                EngineIoSocket.this.onPacket((Packet)args[0]);
            }
        });
        transport.on("drain", new Emitter.Listener(){

            public void call(Object ... args) {
                EngineIoSocket.this.flush();
            }
        });
        this.mCleanupFunction = new Runnable(){

            @Override
            public void run() {
                transport.off("error");
                transport.off("close");
                transport.off("packet");
                transport.off("drain");
            }
        };
    }

    private void closeTransport() {
        this.mTransport.close();
    }

    private void clearTransport() {
        if (this.mCleanupFunction != null) {
            this.mCleanupFunction.run();
        }
        this.mTransport.close();
    }

    private void onOpen() {
        this.mReadyState = ReadyState.OPEN;
        JSONArray upgrades = new JSONArray();
        upgrades.put((Object)"websocket");
        JSONObject handshakePacket = new JSONObject();
        handshakePacket.put("sid", (Object)this.mSid);
        handshakePacket.put("upgrades", (Object)upgrades);
        handshakePacket.put("pingInterval", this.mServer.getPingInterval());
        handshakePacket.put("pingTimeout", this.mServer.getPingTimeout());
        Packet openPacket = new Packet("open");
        openPacket.data = handshakePacket.toString();
        this.sendPacket(openPacket);
        this.emit("open", new Object[0]);
        this.resetPingTimeout();
    }

    private void onClose(String reason, String description) {
        if (this.mReadyState != ReadyState.CLOSED) {
            this.mReadyState = ReadyState.CLOSED;
            this.mPingTimer.cancel();
            this.clearTransport();
            this.emit("close", new Object[]{reason, description});
        }
    }

    private void onError() {
        this.onClose("transport error", null);
    }

    private void onPacket(Packet packet) {
        if (this.mReadyState == ReadyState.OPEN) {
            this.emit("packet", new Object[]{packet});
            this.resetPingTimeout();
            switch (packet.type) {
                case "ping": {
                    this.sendPacket(new Packet("pong"));
                    this.emit("heartbeat", new Object[0]);
                    break;
                }
                case "error": {
                    this.onClose("parse error", null);
                    break;
                }
                case "message": {
                    this.emit("data", new Object[]{packet.data});
                    this.emit("message", new Object[]{packet.data});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacket(Packet packet) {
        if (this.mReadyState != ReadyState.CLOSING && this.mReadyState != ReadyState.CLOSED) {
            LinkedList<Packet> linkedList = this.mWriteBuffer;
            synchronized (linkedList) {
                this.mWriteBuffer.add(packet);
            }
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        if (this.mReadyState != ReadyState.CLOSED && this.mTransport.isWritable() && this.mWriteBuffer.size() > 0) {
            Object[] emitArg = this.mWriteBuffer.toArray();
            this.emit("flush", emitArg);
            LinkedList<Packet> linkedList = this.mWriteBuffer;
            synchronized (linkedList) {
                this.mTransport.send(this.mWriteBuffer);
                this.mWriteBuffer.clear();
            }
            this.emit("drain", new Object[0]);
        }
    }

    private void resetPingTimeout() {
        if (this.mPingTimeout != null) {
            this.mPingTimeout.cancel();
        }
        this.mPingTimeout = new TimerTask(){

            @Override
            public void run() {
                EngineIoSocket.this.onClose("ping timeout", null);
            }
        };
        this.mPingTimer.schedule(this.mPingTimeout, this.mServer.getPingInterval() + this.mServer.getPingTimeout());
    }
}

